/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>
#include <assert.h>

#include "jncpWire.h"

#include "NetStreamJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetStream
 *    extends NdsStream
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected boolean value;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetStream)
NetStreamCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetStream;
   jclass clsNetStreamLR;
   //NJCL variables
   pNetStream sNetStream;

   clsNetStreamLR = (*env)->FindClass (env, NETSYNTAXPKG "NetStream");
   clsNetStream = (*env)->NewGlobalRef (env, clsNetStreamLR);
   (*env)->DeleteLocalRef (env, clsNetStreamLR);

   sNetStream = (pNetStream) sysMalloc (sizeof (NetStream));

   if (NULL != sNetStream)
   {
      // assign jclass variables
      sNetStream->cls = clsNetStream;
   }
   return (sNetStream);

} /* NetStreamCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetStreamCreate
(
   JNIEnv *env,
   pNetStream sNetStream,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);

	  assert (length == 0);
   }

   return ((*env)->AllocObject (env, sNetStream->cls));

} /* NetStreamCreate () */


/***** NetAttrRecordJNI.h *************************************************/

/*
 * typedef struct
 * {
 *    nuint32  length;
 *    pnuint8  data;
 * } Stream_T, N_FAR *pStream_T;
 *
 * java array:
 *  | length | data
 */

N_GLOBAL_FUNC_C (jbyteArray)
NetStream_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{
   // JNI variables
   jbyteArray byteArray;
   // NWNet variables
   pStream_T stream;
   nuint8 *streamPtr, *ptr;

   // NdsMemory.handle - ReplicaPointer C struct
   stream = (pStream_T) cValue;

   // malloc temporary buffer
   streamPtr = (nuint8 *) sysMalloc (cLength);
   ptr = streamPtr;

   // build the temporary buffer
   *(nuint32 *) ptr = stream->length;
   ptr += sizeof(nuint32);

   memcpy (ptr, stream->data, stream->length);


   // allocate return byte[]
   byteArray = (*env)->NewByteArray (env, cLength);

   // copy temporary buffer to byte[]
   (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) streamPtr);

   // free temporary buffer
   sysFree (streamPtr);

   return (byteArray);

} /* toByteArray () */

/*
 *
 */
N_GLOBAL_FUNC_C (nptr) 
NetStream_toCStruct
(
   JNIEnv      *env, 
   jbyteArray  values
)
{
   // JNI variables
   jbyte *byteArray, *ptr;
   jsize length;
   // NWNet variables
   pStream_T stream;
   nuint8 *dataPtr;
   nuint32 streamLength;

   // get byte[]
   byteArray = (*env)->GetByteArrayElements (env, values, 0);
   ptr = byteArray;

   // calculate NetMemory size
   length = (*env)->GetArrayLength (env, values) + sizeof(Stream_T);

   // malloc NetMemory buffer
   stream = (pStream_T) sysMalloc (length);
   dataPtr = (nuint8 *)(stream) + sizeof(Stream_T);

   // build the buffer
   stream->length = streamLength = *(nuint32 *) ptr;
   ptr += sizeof(nuint32);

   stream->data = (pnuint8) dataPtr;
   memcpy (stream->data, ptr, streamLength);

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return ((nptr) stream);

} /* toCStruct () */


#ifdef __cplusplus
}
#endif


