/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include "jncpWire.h"

#include "NetTelephoneNumberJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetTelephoneNumber
 *    extends NdsTelephoneNumber
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int remoteId;
 *    protected String name;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetTelephoneNumber)
NetTelephoneNumberCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetTelephoneNumber;
   jclass clsNetTelephoneNumberLR;
   //NJCL variables
   pNetTelephoneNumber sNetTelephoneNumber;

   clsNetTelephoneNumberLR = (*env)->FindClass (env, NETSYNTAXPKG "NetTelephoneNumber");
   clsNetTelephoneNumber = (*env)->NewGlobalRef (env, clsNetTelephoneNumberLR);
   (*env)->DeleteLocalRef (env, clsNetTelephoneNumberLR);

   sNetTelephoneNumber = (pNetTelephoneNumber) sysMalloc (sizeof (NetTelephoneNumber));

   if (NULL != sNetTelephoneNumber)
   {
      // assign jclass variables
      sNetTelephoneNumber->cls = clsNetTelephoneNumber;

      // assign jfieldID variables
      sNetTelephoneNumber->ID.value = (*env)->GetFieldID (env, clsNetTelephoneNumber, "value", "Ljava/lang/String;");
   }
   return (sNetTelephoneNumber);

} /* NetTelephoneNumberCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetTelephoneNumberCreate
(
   JNIEnv *env,
   pNetTelephoneNumber sNetTelephoneNumber,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netTelephoneNumber = (*env)->AllocObject (env, sNetTelephoneNumber->cls);

   {
      jstring value;

      NAlign32 (curPos);
      (*env)->SetObjectField (
                                 env,
                                 netTelephoneNumber,
                                 sNetTelephoneNumber->ID.value,
                        (jobject)(value = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, value);
   }

   return (netTelephoneNumber);

} /* NetTelephoneNumberCreate () */


#ifdef __cplusplus
}
#endif


