/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include <unicode.h>

#include <nwalias.h>

#include "jncpWire.h"

#include "NetUnknownJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetUnknown
 *    extends NdsUnknown
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int remoteId;
 *    protected String name;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetUnknown)
NetUnknownCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetUnknown;
   jclass clsNetUnknownLR;
   //NJCL variables
   pNetUnknown sNetUnknown;

   clsNetUnknownLR = (*env)->FindClass (env, NETSYNTAXPKG "NetUnknown");
   clsNetUnknown = (*env)->NewGlobalRef (env, clsNetUnknownLR);
   (*env)->DeleteLocalRef (env, clsNetUnknownLR);

   sNetUnknown = (pNetUnknown) sysMalloc (sizeof (NetUnknown));

   if (NULL != sNetUnknown)
   {
      // assign jclass variables
      sNetUnknown->cls = clsNetUnknown;

      // assign jfieldID variables
      sNetUnknown->ID.attributeName = (*env)->GetFieldID (env, clsNetUnknown, "attributeName", "Ljava/lang/String;");
      sNetUnknown->ID.syntaxId = (*env)->GetFieldID (env, clsNetUnknown, "syntaxId", "I");
      sNetUnknown->ID.value = (*env)->GetFieldID (env, clsNetUnknown, "value", "[B");
   }
   return (sNetUnknown);

} /* NetUnknownCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetUnknownCreate
(
   JNIEnv *env,
   pNetUnknown sNetUnknown,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netUnknown = (*env)->AllocObject (env, sNetUnknown->cls);

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);
   }

   {
      jstring attributeName;

      (*env)->SetObjectField (
                                 env,
                                 netUnknown,
                                 sNetUnknown->ID.attributeName,
                        (jobject)(attributeName = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, attributeName);
   }

   {
      NAlign32 (curPos);
      (*env)->SetIntField (
                              env,
                              netUnknown,
                              sNetUnknown->ID.syntaxId,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   {
      jbyteArray value;
      // NWNet variables
      pnstr8 cValue;
      nuint32 length;

      cValue = jncpGetData (env, curPos, limit, &length);
      value = (*env)->NewByteArray (env, length); 
      (*env)->SetByteArrayRegion (env, value, 0, length, (jbyte *) cValue); 

      (*env)->SetObjectField (
                                 env,
                                 netUnknown,
                                 sNetUnknown->ID.value,
                       (jobject) value);

      (*env)->DeleteLocalRef (env, value);
   }

   return (netUnknown);

} /* NetUnknownCreate () */


/***** NetAttrRecordJNI.h *************************************************/

/*
 *  typedef struct
 *  {
 *     pnchar        attrName;
 *     NWSYNTAX_ID   syntaxID;
 *     NWLEN         valueLen;
 *     void          *value;
 *  } Unknown_Attr_T;
 *
 * java array:
 *  | attrName | syntaxId | valueLen | value
 */

N_GLOBAL_FUNC_C (jbyteArray)
NetUnknown_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{
   // JNI variables
//   jclass cls;
//   jmethodID getHandleMid, getSizeMid;
//   jint nhdlMemory, length;
   jbyteArray byteArray;
   // NWNet variables
   pUnknown_Attr_T unknown;
   nuint8 *unknownPtr, *ptr;
   NWLEN valueLength;

   // NdsMemory methods
//   cls = (*env)->GetObjectClass (env, values);
//   getHandleMid = (*env)->GetMethodID (env, cls, "getHandle", "()I");
//   getSizeMid = (*env)->GetMethodID (env, cls, "getSize", "()I");

   // NdsMemory.handle - ReplicaPointer C struct
//   nhdlMemory = (*env)->CallIntMethod (env, values, getHandleMid);
//   unknown = (pUnknown_Attr_T) nhdlMemory;
   unknown = (pUnknown_Attr_T) cValue;

   // NdsMemory.size - NWNet buffer size
//   length = (*env)->CallIntMethod (env, values, getSizeMid);

   // malloc temporary buffer
//   unknownPtr = (nuint8 *) sysMalloc (length);
   unknownPtr = (nuint8 *) sysMalloc (cLength);
   ptr = unknownPtr;

   // build the temporary buffer
   unicpy ((unicode *) ptr, (unicode *) unknown->attrName);
   ptr += (unilen ((unicode *) ptr) + 1) * sizeof(unicode);

   *(NWSYNTAX_ID *) ptr = unknown->syntaxID;
   ptr += sizeof(NWSYNTAX_ID);

   *(NWLEN *) ptr = valueLength = unknown->valueLen;
   ptr += sizeof(NWLEN);

   memcpy (ptr, unknown->value, valueLength);

   // allocate return byte[]
//   byteArray = (*env)->NewByteArray (env, length);
   byteArray = (*env)->NewByteArray (env, cLength);

   // copy temporary buffer to byte[]
//   (*env)->SetByteArrayRegion (env, byteArray, 0, length, (jbyte *) unknownPtr);
   (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) unknownPtr);

   // free temporary buffer
   sysFree (unknownPtr);

   return (byteArray);

} /* toByteArray () */


/*
 *
 */
N_GLOBAL_FUNC_C (nptr) 
NetUnknown_toCStruct
(
   JNIEnv      *env, 
   jbyteArray  values
)
{
   // JNI variables
   jbyte *byteArray, *ptr;
   jsize length;
   // NWNet variables
   pUnknown_Attr_T unknown;
   nuint8 *dataPtr;

   // get byte[]
   byteArray = (*env)->GetByteArrayElements (env, values, 0);
   ptr = byteArray;

   // calculate NetMemory size
   length = (*env)->GetArrayLength (env,values) + sizeof (pUnknown_Attr_T);

   // malloc NetMemory buffer
   unknown = (pUnknown_Attr_T) sysMalloc (length);
   dataPtr = (nuint8 *)(unknown) + sizeof(Unknown_Attr_T);

   // build the buffer
   unknown->attrName = (pnchar) dataPtr;
   unicpy ((unicode *) unknown->attrName, (unicode *) ptr);
   length = (unilen ((unicode *) ptr) + 1) * sizeof (unicode);
   ptr += length;
   dataPtr += length;

   unknown->syntaxID = *((NWSYNTAX_ID *) ptr);
   ptr += sizeof(NWSYNTAX_ID);

   unknown->valueLen = *((NWLEN *) ptr);
   ptr += sizeof(NWLEN);

   unknown->value = (void *) dataPtr;
   memcpy (unknown->value, ptr, unknown->valueLen);

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return ((nptr) unknown);

} /* toCStruct () */


#ifdef __cplusplus
}
#endif


