
/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/


#include <sys_api.h>

#include <jni.h>

#include <ntypes.h>

#include <nwdsbuft.h>

#include "NetEntryInfoJNI.h"

#include "jncpWire.h"
#include "jdsEntryList.h"


#define NETPKG         "com/novell/service/jncpv2/net/"
#define JNCPPKG        "com/novell/service/jncp/"


N_EXTERN_FUNC (jobjectArray)
EntryListGetEntries
(
   JDSList list
);

N_EXTERN_FUNC (jobjectArray)
EntryListGetEmptyEntries
(
   JDSList list
);

N_EXTERN_FUNC (void)
EntryListAddEntries
(
   JDSList list,
   pBuf_T entries
);

N_EXTERN_FUNC (void)
EntryListDestroy
(
   JDSList *list
);


JDSListInterface NetEntryListInterface = 
{
   NULL,
   EntryListGetEntries,
   EntryListGetEmptyEntries,
   EntryListAddEntries,
   EntryListDestroy
};


typedef struct tagEntriesNode
{
   nuint32 count;
   pBuf_T buf;

   struct tagEntriesNode N_FAR *next;

} EntriesNode, N_FAR *pEntriesNode;

typedef struct tagEntryList
{
   nuint32 count;

   pEntriesNode node;

   JNIEnv *env;

   pNetEntryInfo sNetEntryInfo;

} EntryList, N_FAR *pEntryList;


/*
 *
 */
N_GLOBAL_FUNC (JDSList)
jdsEntryListCreate
(
   JNIEnv *env,
   pNetEntryInfo sNetEntryInfo
)
{
   // JNCP variables
   pJDSListInterface list;
   pEntryList entries;

   list = (pJDSListInterface) sysMalloc (sizeof (JDSListInterface));
   entries = (pEntryList) sysMalloc (sizeof (EntryList));

   *list = NetEntryListInterface;
   list->data = entries;

   entries->count = 0;
   entries->node = NULL;
   entries->env = env;
   entries->sNetEntryInfo = sNetEntryInfo;

   return (list);

} /* EntryListCreate () */

/*
 *
 */
N_GLOBAL_FUNC (jobjectArray)
EntryListGetEmptyEntries
(
   JDSList list
)
{
   // JNCP variables
   pEntryList entryList = (pEntryList) list->data;
   pNetEntryInfo sNetEntryInfo = entryList->sNetEntryInfo;
   // JNI variables
   JNIEnv *env = entryList->env;

   return ((*env)->NewObjectArray (env, 0, sNetEntryInfo->cls, NULL));

} /* EntryListGetEmptyEntries () */


/*
 *
 */
N_GLOBAL_FUNC (jobjectArray)
EntryListGetEntries
(
   JDSList list
)
{
   // JNCP variables
   pEntryList entryList = (pEntryList) list->data;
   pNetEntryInfo sNetEntryInfo = entryList->sNetEntryInfo;
   pEntriesNode node;
   // JNI variables
   JNIEnv *env = entryList->env;
   jobjectArray entries = NULL;
   // NWNet variables
   nuint32 position = 0;

   entries = (*env)->NewObjectArray (env, entryList->count, sNetEntryInfo->cls, NULL);

   for (node = entryList->node; NULL != node; node = node->next)
   {
      nuint32 i;
      pBuf_T buf = node->buf;

      for (i = 0; i < node->count; i++)
      {
         jobject netEntryInfo = NetEntryInfoCreate (env, sNetEntryInfo, buf);

         (*env)->SetObjectArrayElement (env, entries, (jsize) position++, netEntryInfo);

         (*env)->DeleteLocalRef (env, netEntryInfo);
      }
   }
   return (entries);

} /* EntryListGetEntries () */

/*
 *
 */
N_GLOBAL_FUNC (void)
EntryListAddEntries
(
   JDSList list,
   pBuf_T buf
)
{
   // JNCP variables
   pEntryList entryList = (pEntryList) list->data;
   pEntriesNode node;
   // JNI variables
   JNIEnv *env = entryList->env;

   node = (pEntriesNode) sysMalloc (sizeof (EntriesNode));

   entryList->count += node->count = jncpGetInt32 (env, &buf->curPos, buf->data + buf->curLen);

   node->buf = buf;

   node->next = entryList->node;
   entryList->node = node;

} /* EntryListAddEntries () */


/*
 *
 */
N_GLOBAL_FUNC (void)
EntryListDestroy
(
   JDSList N_FAR *list
)
{
   // JNCP variables
   pEntryList entryList = (pEntryList) (*list)->data;

   while (entryList->node)
   {
      pEntriesNode node = entryList->node;

      entryList->node = node->next;
      NWDSFreeBuf (node->buf);
      sysFree (node);
   }
   sysFree (entryList);
   sysFree ((JDSListInterface *) *list);
   *list = NULL;

} /* EntryListDestroy () */


