#ifndef __libtypes_h__
#define __libtypes_h__
/*============================================================================
=	NetWare Loadable Modules / Server Library Internal Header
=
=	Unpublished Copyright (C) 1996-1997 by Novell, Inc. All rights reserved.
=
=	No part of this file may be duplicated, revised, translated, localized or
=	modified in any manner or compiled, linked or uploaded or downloaded to or
=	from any computer system without the prior written consent of Novell, Inc.
==============================================================================
=							I n t e r n a l   H e a d e r
=
=	This file began mostly as a way to deal with upcoming 64-bit questions. A
=	few generic types to replace LONG and int were needed to hide the 64-bit
=	question later by making them void *. Integers (and LONGs) will no longer
=	cover pointers. For example, under traditional NetWare, T_Thread is equi-
=	valent to LONG or int and under MPK NetWare, it is equivalent to MPKThread.
=	The same is done for thread group and process IDs. These are all basically
=	just opaque pointers that can become 64 bits wide under compiler influence.
=	This file grows as new situations are found. It may be included by any file
=	that needs these definitions as it stands alone.
=
=	libtypes.h
==============================================================================
*/

/* the new type defined represents: */
typedef void	*T_NLM;				/* NLM IDs */
typedef void	*T_Thread;			/* thread IDs */
typedef void	*T_ThreadGroup;	/* thread group IDs */
typedef void	*T_Process;			/* process IDs */
typedef void	*T_Mutex;			/* old semaphores, SMP and MPK mutexes */
typedef void	*T_Semaphore;		/* old, SMP and MPK semaphores */
typedef void	*T_RwLock;			/* reader-writer locks */
typedef void	*T_CondVar;			/* condition variables */
typedef void	*T_SpinLock;		/* spin locks */

/* shorter aliases for above: */
typedef T_Semaphore	T_Sem, T_Sema;

#endif
