/*
 * Copyright (c) 1993-1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * The Java source code is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You shall
 * not disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.

 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
/*
 * @(#)io_md.h  1.14 95/11/16
 *
 */

/*
 * NetWare system dependent low level io definitions
 */

#ifndef _NW_IO_MD_H_
#define _NW_IO_MD_H_

#include <sys/types.h>
#include <ctype.h>
#include <stdlib.h>
#include <dirent.h>
#include <io.h>

#define R_OK    4
#define W_OK    2
#define X_OK    1
#define F_OK    0

#define MAXPATHLEN _MAX_PATH

// This is a little tricky on NetWare. From Clib point of view,
// server/volume:path1/path2/.../pathn/file.ext is only absolute path,
// but from OS point of view volume:path1/path2/.../pathn/file.ext is an
// absolute path.
//
// Additionally the java.io.File.getAbsolutePath method is implemented as:
//  return isAbsolute() ? path : System.getProperty("user.dir") + separator + path;
// (the user.dir property is set to server/volume:). This means that if isAbsolute
// says that a path like sys:system is absolute, that getAbsolutePath will return
// a bogus path, ie server\sys:\sys:system. So for now server/volume:path and
// volume:path are absolute paths.

int sysOpen(const char *, int, int);
int sysClose(int);
int sysAccess(const char *, int);
int sysStat(const char *, struct stat *);
int sysMkdir(const char *, int);
int sysUnlink(const char *);
int sysAvailable(int fd, long *bytes);
DIR *sysOpenDir(const char *path);
DIR *sysReadDir(DIR *dirP);
int sysCloseDir(DIR *dirP);

size_t sysRead(int fd, void *buf, unsigned int n);
size_t sysWrite(int fd, const void *buf, unsigned int n);

#define sysSeek(path, oflag, mode)    lseek(path, oflag, mode)
#define sysRename(src,dst)	rename(src,dst)
// #define sysClose(fd)            close(fd)
// #define sysReadDir(dirp)        readdir(dirp)
// #define sysCloseDir(dirp)       closedir(dirp)

#endif /* !_NW_IO_MD_H_ */
