#ifndef _NDS_H_INCLUDED
#define _NDS_H_INCLUDED
/*============================================================================
=	NetWare Loadable Modules / Server Library Internal Header
=
=	Unpublished Copyright (C) 1996-1997 by Novell, Inc. All rights reserved.
=
=	No part of this file may be duplicated, revised, translated, localized or
=	modified in any manner or compiled, linked or uploaded or downloaded to or
=	from any computer system without the prior written consent of Novell, Inc.
==============================================================================
=							I n t e r n a l   H e a d e r
=	nds.h
==============================================================================
*/
#include <nwtypes.h>
#include <nwconn.h>

#define SUCCESS						0
#define LOCAL_SERVER					(-1)
#define BAD_TDSTAG 					(-1)
#define NDSSERVER_NOT_FOUND		(-1)
#define OUT_OF_MEMORY				(-1)
#define INVALID_USER					(-2)
#define TDSDATA_TRUNCATED			(-2)
#define NO_USER						(-3)
#define NO_CONTEXT_BUFFER			(-4)
#define NO_CONNECTION				(-4)
#define NIL_NAME_OR_NULL_LENGTH	(-5)		/* NWDSSetPreferredDSTree */

#define NWNDS_CONNECTION			0x0001
#define NWNDS_AUTHENTICATED		0x0004

/* errors which must be mapped appropriately by DSAPI.NLM source code */
#define kContextCreationError		-1

/*============================================================================*/
/* Directory Services context support data structures furnished by CLib...    */
typedef struct _DSCNode				/* nth one of these corresponds to DCTable[n	*/
{											/* -1], only the DSAPI sources understand    */
	struct _DSCNode	*next;		/* our structures, but we don't know theirs,	*/
	void					*context;	/* hence the void pointer. If this pointer   */
	unsigned long		userID;		/* is nil, the node has been freed and may   */
} DSContext, *DSContextPtr;		/* be reused... */

typedef struct
{
	char				signature[4];	/* '<DS>'--so I can find it in debugging */
	DSContextPtr	DCTable;			/* replaces finite array on the client   */
} DSGlobalStruct;

/* correct version of fragment structure for use by 386... */
/* Removed in this local copy by djharris...rchilders aware...needs to be
   removed from original.  5/7/98 */
#if 0
typedef struct
{
	void	*fragAddress;
	LONG	fragSize;					/* this differs from client side */
} NW_FRAGMENT;
#endif


/* the Directory Services user structure */
typedef struct NDSTDSStructure
{
	struct NDSTDSStructure	*link;
	struct NDSTDSStructure	*prev;
	LONG							tdsTag;
	LONG							maxSize;
/*-0x10------------------------------------------*/
	LONG							size;
	LONG							flags;
	BYTE							*data;
} NDSTDSStructure;

typedef struct NDSUserStructure
{
	struct NDSUserStructure	*link;
	struct NDSUserStructure	*prev;
	int							UserTag;
	WORD							AutTag;
	BYTE							pad[2];
/*-0x10--------------------*/
	int							AutSize;
	BYTE							*AutData;
/*-0x18------------------------------------------*/
	BYTE							Context[256];
	NDSTDSStructure			*tdsStruct;
} NDSUserStructure;

/* DS context function prototypes... */
int				DSCreateContext	( void );
DSContextPtr	DSGetContextPtr	( int cH );
int				DSValidateContext	( int );
int				DSValidateUserID	( DSContextPtr cH );
void				DSFreeContext		( DSContextPtr cH );
void				DSDeinit				( void *dsg );
/*
	--The following are now macros...
unsigned long	DSGetUserID			( DSContextPtr cH );
void				DSSetUserID			( DSContextPtr cH, unsigned long userID );
*/
#define DSGetUserID( cH )			((DSContextPtr) cH)->userID
#define DSSetUserID( cH, uID )	((DSContextPtr) cH)->userID = uID
/*============================================================================*/

#define NWDSSetConnectionInfo		DSSetConnectionStatus
#define DSSetConnectionInfo		DSSetConnectionStatus

/* surfaced functions (to external developer other than DSAPI library)... */
int	NWDSGetPreferredDSTree( int length, char *treeName );
int	NWDSGetDefaultNameContext( int contextSize, BYTE *contextBuf );

/* 'NWDS-' but not surfaced to developer... */
int	NWDSCreateUser( void );
int	NWDSDeleteUser( int userHandle );

/* function prototypes for remaining Directory Services support... */
void	_NWDSInit( void );
int	_GetDSTreeFromConn( int conn, int length, char *treeName );
void	DSCleanUpDSAPIsConnections( void );
int	_DSCleanupUsers( void );
int	DSGetNearestConnectionToTree( int treeLen, char *treeName, int *connH );
int	DSAllocTDSData( int tag, int bytesRequested, int flags );
int	DSCheckIfConnection( char *serverName );
int	DSFreeConnectionSlot( int connectionHandle );
int	DSFreeTDSData( int tag );
int	DSGetConnectionHandle( int connectionHandle, int *localConnection );
int	DSGetConnectionIDFromAddress( BYTE transType, LONG transLen,
			BYTE *transBuf, int *connectionHandle );
int	DSGetConnectionInfo( int connectionHandle, BYTE *connectionStatus,
		BYTE *connectionType, BYTE *serverFlags, BYTE *serverName,
		BYTE *transType, LONG *transLen, BYTE *transBuf, int *distance,
		int *maxPacketSize );
int	DSGetConnectionSlot( BYTE connectionType, BYTE transType, LONG transLen,
		BYTE *transBuf, int *connectionHandle );
int	DSGetNearestDirectoryService( int *connectionHandle );
int	DSGetNumConnections( int *numConnections );
int	DSGetTDSControlInfo( int tag, int *maxDataSiz, int *dataSiz, int *flags );
int	DSReadFromTDS( int tag, int bytesRequested, int offset, BYTE *dataPointer,
		int *copiedDataSize );
int	DSCloseFileHandle( int connectionHandle, LONG fileHandle );
int	DSConvertFileHandle( int connectionHandle, int access, LONG fileHandle,
		LONG fileSize, int *convertedHandle );
int	DSSetLicensedBit( int connectionHandle, BYTE status );
#define kLB_Temp		0			/* for 'status' argument... */
#define kLB_Logged	1
int	DSSend( LONG connectionHandle, BYTE functionCode, char *sendPacket,
		WORD sendLength, char *replyBuf, WORD replyLength );
int	DSSetConnectionStatus( int connectionHandle, BYTE connectionType );
int	DSWriteToTDS( int tag, int numBytes, int offset, BYTE *dataPointer );

/* security Stuff for DS... */
void	_NWGetSecurityFlags( int conn, int *secFlags );
int	NWGetSessionKey( int conn, char *sessionKeyComponents, char *sessionKey );
int	_NWCreateSessionKey( int conn, char *sessionKeyComponents );

#ifndef NCPSEND_INTERNALLY_DEFINED
int	DSSendToLocalServer( int serverHandle, BYTE FunctionCode,
		char *sendPacket, WORD length, char *replyBuf );
int	DSGetFileServerVersion( int conn, WORD *version );
#endif

/* new prototypes... */
void	*CurrentNCSDSGlobals( void );
void	*NCSDSGlobals( void *ncsp );	/* --get 'ncsp' from InternalNLMID() */

#endif
