/*
 * NATIVE_MAIN
 */

#include <nwthread.h>
#include <nwadv.h>
#include <ntypes.h>
#include <signal.h>

#include "jncp.h"
#include "JNIString.h"
#include "binderyJNI.h"
#include "netJNI.h"

#pragma unreferenced (on)
N_GLOBAL_VAR char *productStr = JNCP_PRODUCT_STRING;
N_GLOBAL_VAR char *versionStr = JNCP_VERSION_STRING;
N_GLOBAL_VAR char *copyrightStr = JNCP_COPYRIGHT_STRING;
#pragma unreferenced (off)

N_GLOBAL_VAR int _JNCPThreadGroupID;


/**
 *
 */
N_GLOBAL_FUNC(void)
 __InitNWCalls(void)
{
   NWCallsInit(NULL, NULL);
}

/**
 *
 */
N_GLOBAL_FUNC(void)
__CleanupNWCalls(void)
{
   NWCallsTerm(NULL);
}


/*
 *
 */
void cleanup(int sig)
{
   int save = GetThreadGroupID();

   SetThreadGroupID(_JNCPThreadGroupID);

   __CleanupNativeUnicode();  // make sure unicode is uninit'd before NWCalls
   __CleanupNWCalls();

   SetThreadGroupID(save);
}


/*
 * main ()
 *
 * Main entry point -- don't do anything after the call to SynchronizeStart.
 * The loader process sleeps until the call to SynchronizeStart, so we DO
 * have a data segment when Java auto-loads us.  If this were not a
 * synchronized NLM, then we'd be forced to put all this resource
 * initialization in a native method, which would make Java's resource tag
 * get all of our memory allocation for unicode tables, etc.
 *
 * Entry:
 *
 * Exit:
 *    Nothing
 */

void main ()
{
   _JNCPThreadGroupID = GetThreadGroupID();

   __InitNWCalls();        // make sure NWCalls is init'd before unicode
   __InitNativeUnicode();

   signal(SIGTERM, cleanup);

} /* main() */


