/* **************************************************************************

  %name: serverJNI.c %
  %version: 6 %
  %date_modified: Tue Jan 27 13:50:40 1998 %
 
  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
#include <jni.h>
#include "com_novell_service_jncpv2_cal_CalJNI.h"
#include <ntypes.h>
#include <nwcalls.h>
#include <nwsm.h>
#include "JNIString.h"
#include "jncp.h"

#define MAX_COMPANY_NAME_LEN 81           // 80 chars + NULL
#define MAX_REVISION_LEN 81               // 80 chars + NULL
#define MAX_REVISION_DATE_LEN 25          // 24 chars + NULL
#define MAX_COPYRIGHT_LEN 81              // 80 chars + NULL
#define TIMEBUF_LEN 7

JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2_cal_CalJNI_NWGetFileServerDescription
(
   JNIEnv   *env,
   jclass   obj,
   jint     connHandle,
   jobject  companyName,
   jobject  revision,
   jobject  revisionDate,
   jobject  copywrightNotice
)
{
   jclass cls;
   jmethodID mid;
   jstring str;

   NWCCODE ccode;
   nstr8 cCompanyName[MAX_COMPANY_NAME_LEN];
   nstr8 cRevision[MAX_REVISION_LEN];
   nstr8 cRevisionDate[MAX_REVISION_DATE_LEN];
   nstr8 cCopyrightNotice[MAX_COPYRIGHT_LEN];

   ccode = NWGetFileServerDescription(connHandle, cCompanyName,
      cRevision, cRevisionDate, cCopyrightNotice);

   if (0 == ccode)
   {
      unicode buf[MAX_COMPANY_NAME_LEN];  // largest string possible

      cls = (*env)->GetObjectClass(env,companyName);
      mid = (*env)->GetMethodID(env,cls,"append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      ccode = __LocalToJavaStr (env, &str, buf, cCompanyName);
      if (ccode != 0)  // possible Java exception
         return (ccode);
      (*env)->CallObjectMethod(env, companyName, mid, str);
      
      cls = (*env)->GetObjectClass(env,revision);
      mid = (*env)->GetMethodID(env,cls,"append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      ccode = __LocalToJavaStr (env, &str, buf, cRevision);
      if (ccode != 0)  // possible Java exception
         return (ccode);
      (*env)->CallObjectMethod(env, revision, mid, str);

      cls = (*env)->GetObjectClass(env,revisionDate);
      mid = (*env)->GetMethodID(env,cls,"append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      ccode = __LocalToJavaStr (env, &str, buf, cRevisionDate);
      if (ccode != 0)  // possible Java exception
         return (ccode);
      (*env)->CallObjectMethod(env, revisionDate, mid, str);

      cls = (*env)->GetObjectClass(env,copywrightNotice);
      mid = (*env)->GetMethodID(env,cls,"append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      ccode = __LocalToJavaStr (env, &str, buf, cCopyrightNotice);
      if (ccode != 0)  // possible Java exception
         return (ccode);
      (*env)->CallObjectMethod(env, copywrightNotice, mid, str);
   }
   return ccode;
}

JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2_cal_CalJNI_NWGetFileServerLoginStatus
(
   JNIEnv   *env, 
   jclass   obj, 
   jint     connHandle, 
   jobject  info
)
{
   jclass cls;
   jmethodID mid;
   NWCCODE ccode;
   nuint8  cStatus;

   ccode = NWGetFileServerLoginStatus(connHandle, &cStatus);

   if (0 == ccode)
   {  // Need to convert 'C' variables back into Java variables
      cls = (*env)->GetObjectClass(env,info);

      mid = (*env)->GetMethodID(env,cls,"setValue","(I)V");
      (*env)->CallVoidMethod(env,info,mid,cStatus);
   }
   return (long)ccode;
}

JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2_cal_CalJNI_NWGetFileServerVersionInfo
(
   JNIEnv   *env, 
   jclass   obj, 
   jint     connHandle, 
   jobject  info
)
{
   jclass cls;
   jfieldID fid;
   NWCCODE ccode;
   VERSION_INFO cVersionInfo;

   ccode = NWGetFileServerVersionInfo(connHandle, &cVersionInfo);

   if (0 == ccode)
   {  // Need to convert 'C' variables back into Java variables
      cls = (*env)->GetObjectClass(env,info);

      fid = (*env)->GetFieldID(env,cls,"iFileVersion","I");
      (*env)->SetIntField(env,info,fid,cVersionInfo.fileServiceVersion);
      fid = (*env)->GetFieldID(env,cls,"iFileSubVersion","I");
      (*env)->SetIntField(env,info,fid,cVersionInfo.fileServiceSubVersion);
      fid = (*env)->GetFieldID(env,cls,"iMaximumConnections","I");
      (*env)->SetIntField(env,info,fid,cVersionInfo.maximumServiceConnections);
      fid = (*env)->GetFieldID(env,cls,"iConnectionsInUse","I");
      (*env)->SetIntField(env,info,fid,cVersionInfo.connectionsInUse);
      fid = (*env)->GetFieldID(env,cls,"iMaxVolumes","I");
      (*env)->SetIntField(env,info,fid,cVersionInfo.maxNumberVolumes);
      fid = (*env)->GetFieldID(env,cls,"iRevision","I");
      (*env)->SetIntField(env,info,fid,cVersionInfo.revision);
      fid = (*env)->GetFieldID(env,cls,"iSFTLevel","I");
      (*env)->SetIntField(env,info,fid,cVersionInfo.SFTLevel);
      fid = (*env)->GetFieldID(env,cls,"iTTSLevel","I");
      (*env)->SetIntField(env,info,fid,cVersionInfo.TTSLevel);
      fid = (*env)->GetFieldID(env,cls,"iMaxConnectionsEverUsed","I");
      (*env)->SetIntField(env,info,fid,cVersionInfo.maxConnectionsEverUsed);
      fid = (*env)->GetFieldID(env,cls,"iAccountVersion","I");
      (*env)->SetIntField(env,info,fid,cVersionInfo.accountVersion);
      fid = (*env)->GetFieldID(env,cls,"iQueueVersion","I");
      (*env)->SetIntField(env,info,fid,cVersionInfo.queueVersion);
      fid = (*env)->GetFieldID(env,cls,"iPrintVersion","I");
      (*env)->SetIntField(env,info,fid,cVersionInfo.printVersion);
      fid = (*env)->GetFieldID(env,cls,"iVirtualConsoleVersion","I");
      (*env)->SetIntField(env,info,fid,cVersionInfo.virtualConsoleVersion);
      fid = (*env)->GetFieldID(env,cls,"iSecurityVersion","I");
      (*env)->SetIntField(env,info,fid,cVersionInfo.restrictionLevel);
      fid = (*env)->GetFieldID(env,cls,"iInternetBridgeVersion","I");
      (*env)->SetIntField(env,info,fid,cVersionInfo.internetBridge);
   }
   return (long)ccode;
}

JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2_cal_CalJNI_NWSMLoadNLM
(
   JNIEnv      *env,
   jclass      obj,
   jint        connHandle,
   jstring     loadCommand
)
{
   NWRCODE ccode;
   punicode uniCommand = (punicode) (*env)->GetStringChars(env, loadCommand, NULL);
   nstr8 command[483];  // max load/unload length

   ccode = __UnicodeToLocalStr(command, sizeof(command),
         uniCommand, (*env)->GetStringLength(env, loadCommand));
   if (ccode != 0)
      goto EXIT;

   ccode = NWSMLoadNLM(connHandle, command);

EXIT:

   (*env)->ReleaseStringChars (env, loadCommand, uniCommand);

   return (ccode);
}

JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2_cal_CalJNI_NWSMUnloadNLM
(
   JNIEnv      *env,
   jclass      obj,
   jint        connHandle,
   jstring     NLMName
)
{
   NWRCODE ccode;
   punicode uniNLMName = (punicode) (*env)->GetStringChars(env, NLMName, 0);
   nstr8 cNLMName[483];  // max load/unload length

   ccode = __UnicodeToLocalStr(cNLMName, sizeof(cNLMName),
         uniNLMName, (*env)->GetStringLength(env, NLMName));
   if (ccode != 0)
      goto EXIT;

   ccode = NWSMUnloadNLM(connHandle, cNLMName);

EXIT:

   (*env)->ReleaseStringChars (env, NLMName, uniNLMName);

   return (ccode);
}

JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2_cal_CalJNI_NWGetFileServerDateAndTime
(
   JNIEnv *env,
   jclass obj,
   jint   connHandle,
   jobjectArray holder
)
{
   jbyteArray arr;
   nuint8 dateBuffer[TIMEBUF_LEN];

   NWRCODE ccode = NWGetFileServerDateAndTime(connHandle, dateBuffer);
   if(ccode == 0)
   {
      arr = (*env)->NewByteArray(env, TIMEBUF_LEN);
      (*env)->SetByteArrayRegion(env, arr, 0, (jsize)TIMEBUF_LEN,
            (jbyte *)dateBuffer);
      (*env)->SetObjectArrayElement(env, holder, 0, arr);
   }
   return ccode;
}

JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2_cal_CalJNI_NWSetFileServerDateAndTime
(
   JNIEnv *env,
   jclass obj,
   jint   connHandle,
   jint   year,
   jint   month,
   jint   day,
   jint   hour,
   jint   minute,
   jint   second
)
{
   return NWSetFileServerDateAndTime( connHandle, (nuint8)year, (nuint8)month,
      (nuint8)day, (nuint8)hour, (nuint8)minute, (nuint8)second);
}

JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2_cal_CalJNI_NWGetFileServerInfo
(
   JNIEnv   *env, 
   jclass   obj, 
   jint     connHandle, 
   jobject  info
)
{
   jclass cls;
   jfieldID fid;
   NWCCODE ccode;
   NWFSE_FILE_SERVER_INFO cServerInfo;

   ccode = NWGetFileServerInfo(connHandle, &cServerInfo);

   if (0 == ccode)
   {  // Need to convert 'C' variables back into Java variables
      cls = (*env)->GetObjectClass(env,info);

      fid = (*env)->GetFieldID(env,cls,"serverUpTime","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.serverTimeAndVConsoleInfo.currentServerTime);
      fid = (*env)->GetFieldID(env,cls,"numOfNCPRequests","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.numOfNCPRequests);
      fid = (*env)->GetFieldID(env,cls,"serverCPUUtilization","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.serverUtilization);
      fid = (*env)->GetFieldID(env,cls,"replyCanceledCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.replyCanceledCount);
      fid = (*env)->GetFieldID(env,cls,"writeHeldOffCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.writeHeldOffCount);
      fid = (*env)->GetFieldID(env,cls,"writeHeldOffWithDupRequest","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.writeHeldOffWithDupRequest);
      fid = (*env)->GetFieldID(env,cls,"invalidRequestTypeCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.invalidRequestTypeCount);
      fid = (*env)->GetFieldID(env,cls,"beingAbortedCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.beingAbortedCount);
      fid = (*env)->GetFieldID(env,cls,"alreadyDoingReallocCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.alreadyDoingReallocCount);
      fid = (*env)->GetFieldID(env,cls,"deAllocInvalidSlotCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.deAllocInvalidSlotCount);
      fid = (*env)->GetFieldID(env,cls,"deAllocBeingProcessedCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.deAllocBeingProcessedCount);
      fid = (*env)->GetFieldID(env,cls,"deAllocForgedPacketCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.deAllocForgedPacketCount);
      fid = (*env)->GetFieldID(env,cls,"deAllocStillTransmittingCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.deAllocStillTransmittingCount);
      fid = (*env)->GetFieldID(env,cls,"startStationErrorCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.startStationErrorCount);
      fid = (*env)->GetFieldID(env,cls,"invalidSlotCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.invalidSlotCount);
      fid = (*env)->GetFieldID(env,cls,"beingProcessedCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.beingProcessedCount);
      fid = (*env)->GetFieldID(env,cls,"forgedPacketCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.forgedPacketCount);
      fid = (*env)->GetFieldID(env,cls,"stillTransmittingCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.stillTransmittingCount);
      fid = (*env)->GetFieldID(env,cls,"reExecuteRequestCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.reExecuteRequestCount);
      fid = (*env)->GetFieldID(env,cls,"invalidSequenceNumCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.invalidSequenceNumCount);
      fid = (*env)->GetFieldID(env,cls,"duplicateIsBeingSentAlreadyCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.duplicateIsBeingSentAlreadyCnt);
      fid = (*env)->GetFieldID(env,cls,"sentPositiveAcknowledgeCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.sentPositiveAcknowledgeCount);
      fid = (*env)->GetFieldID(env,cls,"sentDuplicateReplyCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.sentDuplicateReplyCount);
      fid = (*env)->GetFieldID(env,cls,"noMemForStationCtrlCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.noMemForStationCtrlCount);
      fid = (*env)->GetFieldID(env,cls,"noAvailableConnsCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.noAvailableConnsCount);
      fid = (*env)->GetFieldID(env,cls,"reallocSlotCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.reallocSlotCount);
      fid = (*env)->GetFieldID(env,cls,"reallocSlotCameTooSoonCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.ServerInfo.reallocSlotCameTooSoonCount);
      fid = (*env)->GetFieldID(env,cls,"tooManyHops","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.fileServerCounters.tooManyHops);
      fid = (*env)->GetFieldID(env,cls,"unknownNetwork","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.fileServerCounters.unknownNetwork);
      fid = (*env)->GetFieldID(env,cls,"noSpaceForService","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.fileServerCounters.noSpaceForService);
      fid = (*env)->GetFieldID(env,cls,"noReceiveBuffers","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.fileServerCounters.noReceiveBuffers);
      fid = (*env)->GetFieldID(env,cls,"notMyNetwork","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.fileServerCounters.notMyNetwork);
      fid = (*env)->GetFieldID(env,cls,"netBIOSProgatedCount","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.fileServerCounters.netBIOSProgatedCount);
      fid = (*env)->GetFieldID(env,cls,"totalPacketsServiced","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.fileServerCounters.totalPacketsServiced);
      fid = (*env)->GetFieldID(env,cls,"totalPacketsRouted","I");
      (*env)->SetIntField(env,info,fid,cServerInfo.fileServerCounters.totalPacketsRouted);
   }
   return (long)ccode;
}
