
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/jncpv2/net/BasicNetService.java $
  $Revision: 47 $
  $Modtime: 6/11/03 11:12a $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.jncpv2.net;


import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;

import com.novell.service.jncp.NSIExceptionBuilder;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.clx.ClxJNI;

import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.Connection;
import com.novell.service.session.xplat.NDSContext;
import com.novell.service.session.xplat.NDSContextInfo;
import com.novell.service.session.xplat.NativeContext;
import com.novell.service.session.xplat.Natives;


import com.novell.service.toolkit.jcl.NWInteger;
import com.novell.service.toolkit.jcl.NWBoolean;


/** @internal
 * Object returned by Session.getService() that wraps all NWNET
 * native services (via NetJNI).
 */
public class BasicNetService
   implements NetService
{
   /**
    * The key used to generate an object of this type via the
    * Session.getService() interface.
    */
// Please leave OLD versions here but commented out for the purpose of
// tracking unique identifiers.
//   public static final String KEY =
//"com.novell.service.jncpv2.net.NetService.1039844522";
   public static final String KEY =
"com.novell.service.jncpv2.net.BasicNetService.1039844522";


   /**
    * Optimization data for listEntries() and readEntry()
    */
   private static int sNetEntryInfo;

   /**
    * Optimization data for readAttributes()
    */
   private static int sNetAttrRecord;


   static
   {
      /*
       * A bug in the JDK 1.1 VM causes it to garbage collect classes much 
       * too aggressively. (This bug has been fixed in the 1.2x VM 
       * implementations) 
       */
      Thread t = new Thread ("BasicNetService")
         {
            private Class cls = BasicNetService.class;

            public synchronized void run ()
            {
               try
               {
                  wait ();
               }
               catch (InterruptedException e)
               {
               }
            }
         };

      t.setDaemon (true);
      t.start ();

      sNetEntryInfo = NetJNI.JDSGetEntryInfoStruct ();
      sNetAttrRecord = NetJNI.JDSGetAttrRecordStruct ();
   }


   protected NDSContext context;
   protected int threadGroup;
   protected int hdlContext;
   NativeContext nativeContext;
//   protected Connection connection;
//   protected int hdlConnection;

   /**
    *
    */
   public BasicNetService (
         NDSContext context)
      throws SessionException
   {
      this.context = context;
      nativeContext = context.getNativeHandle();
      threadGroup = nativeContext.threadGroup;
      hdlContext = context.getHandle();
//      this.connection = context.getConnection ();
//      hdlConnection = connection.getHandle ();
   }


   // ******************** Context Interface ********************

   /**
    *
    */
   public void setConfidence (
         int level)
      throws SessionException
   {
      int ccode;

      // set DCK_CONFIDENCE
      ccode = ClxJNI.NWDSSetContext (
                        threadGroup,
                        hdlContext,
                        ClxJNI.DCK_CONFIDENCE,
                        new Integer (level));
      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }
   }

   /**
    *
    */
   public void setNameCacheDepth (
         int depth)
      throws SessionException
   {
      int ccode;

      // set DCK_CONFIDENCE
      ccode = ClxJNI.NWDSSetContext (
                        threadGroup,
                        hdlContext,
                        ClxJNI.DCK_NAME_CACHE_DEPTH,
                        new Integer (depth));
      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }
   }

   /**
    *
    */
   public void setTypelessNames (
         boolean flag)
      throws SessionException
   {
      int ccode;
      Integer flags;
      NDSContextInfo info = new NDSContextInfo ();

      // Get flags on the context handle.
      ccode = ClxJNI.NWDSGetContext (
                                       threadGroup,
                                       hdlContext,
                                       ClxJNI.DCK_FLAGS,
                                       info);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      flags = (Integer) info.getValue ();
      if (flag)
      {
         // turn DCV_TYPELESS_NAMES on
         flags = new Integer (
                        flags.intValue () | ClxJNI.DCV_TYPELESS_NAMES);
      }
      else
      {
         // turn DCV_TYPELESS_NAMES off
         flags = new Integer (
                        flags.intValue () & ~ClxJNI.DCV_TYPELESS_NAMES);
      }

      // set DCK_FLAGS
      ccode = ClxJNI.NWDSSetContext (
                        threadGroup,
                        hdlContext,
                        ClxJNI.DCK_FLAGS,
                        flags);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* setTypelessNames () */


   public final String canonicalizeName
   (
      String objectName
   )
   throws SessionException
   {
      StringBuffer canonName = new StringBuffer();
      int ccode = NetJNI.NWDSCanonicalizeName(
            threadGroup,
            this.hdlContext,
            objectName,
            canonName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return canonName.toString();
   }


   /**
    *
    */
   public final String getServerDN ()
      throws SessionException
   {
      int ccode;
      StringBuffer serverDN = new StringBuffer ();

      Integer connection = (Integer)Natives.getContextInfo(
            nativeContext,
            Natives.DCK_LAST_CONNECTION);
      int hdlConnection = connection.intValue();

      ccode = NetJNI.NWDSGetServerDN (
                        threadGroup,
                        this.hdlContext,
                        hdlConnection,
                        serverDN);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return (new String (serverDN));

   } /* getServerDN () */


   /**
    *    @deprecated    use addFilterToken() instead
    */
   public final void addFilterToken
   (
      int cur,
      int tok,
      int val,
      int syntaxID
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSAddFilterToken(
         cur,
         tok,
         val,
         syntaxID);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

   }

   /**
    *
    */
   public final void addFilterToken (
         /*in*/   int                  cur,
         /*in*/   int                  tok,
         /*in*/   byte[]               val,
         /*in*/   int                  syntaxID)
      throws SessionException
   {
      int ccode;

      ccode = NetJNI.JDSAddFilterToken (cur, tok, val, syntaxID);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build(ccode);
      }
   }


   /**
    *
    */
   public final void addObject (
      String objectName,
      NetIterationHandle iterationHandle,
      boolean more,
      int buf)
   throws SessionException
   {
      int ccode;

      ccode = NetJNI.NWDSAddObject (
                        threadGroup,
                        this.hdlContext,
                        objectName,
                        iterationHandle,
                        more,
                        buf);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* addObject () */

   /**
    *
    */
   public final int allocBuf (
         int size)
      throws SessionException
   {
      int ccode;
      NWInteger handle = new NWInteger ();

      if ((ccode = NetJNI.NWDSAllocBuf (size, handle)) != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }
      return (handle.getValue ());

   } /* allocBuf () */

   /**
    *
    */
   public final NWInteger allocFilter (
         NWInteger cur)
      throws SessionException
   {
      int ccode = NetJNI.NWDSAllocFilter (cur);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }
      return (cur);

   }

   /**
    *
    */
   public final void dsBackupObject (
         String objectName,
         NetIterationHandle iterationHandle,
         int objectInfo)
      throws SessionException
   {
      int ccode;

      ccode = NetJNI.NWDSBackupObject(
         threadGroup,
         this.hdlContext,
         objectName,
         iterationHandle,
         objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build(ccode);
      }

   } /* dsBackupObject () */

   public final void beginClassItem
   (
         /*in*/   int buf
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSBeginClassItem (
         threadGroup,
         this.hdlContext,
         buf);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public final void compare
   (
         /*in*/   String         object,
         /*in*/   int            buf,
         /*in*/   BooleanBuffer  matched
    )
   throws SessionException
   {
      int ccode = NetJNI.NWDSCompare(
         threadGroup,
         this.hdlContext,
         object,
         buf,
         matched);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode );
   }

   /**
    *
    */
   public final void closeIteration (
         int iterationHandle,
         int operation)
      throws SessionException
   {
      if (operation != NetJNI.DSV_ITERATOR)
	  {
         int ccode;

         ccode = NetJNI.NWDSCloseIteration (
                           threadGroup,
                           this.hdlContext,
                           iterationHandle,
                           operation);

         if (ccode != 0)
         {
            throw NSIExceptionBuilder.build (ccode);
         }
	  }

   } /* closeIteration () */

   public final void freeBuf
   (
         /*in*/   int buf
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSFreeBuf(buf);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    *
    */
   public final int getAttrCount (
         int buf)
      throws SessionException
   {
      int ccode;
      IntegerBuffer attrCount = new IntegerBuffer ();

      ccode = NetJNI.NWDSGetAttrCount (threadGroup, hdlContext, buf,
            attrCount);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }
      return (attrCount.intValue ());

   } /* getAttrCount () */

   public final void getClassDefCount
   (
         /*in*/   int         buf,
         /*out*/  IntegerBuffer   classDefCount
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSGetClassDefCount(
         threadGroup,
         this.hdlContext,
         buf,
         classDefCount);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    *
    */
   public final void getAttrDef (
         int buf,
         StringBuffer attrName,
         NetAttributeInfo attrInfo)
      throws SessionException
   {
      int ccode;

      ccode = NetJNI.NWDSGetAttrDef(
         threadGroup,
         this.hdlContext,
         buf,
         attrName,
         attrInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* getAttrDef () */

   /**
    *
    */
   public final void getClassDef (
         int buf,
         StringBuffer className,
         NetClassInfo classInfo)
      throws SessionException
   {
      int ccode;

      ccode = NetJNI.NWDSGetClassDef(
         threadGroup,
         this.hdlContext,
         buf,
         className,
         classInfo);

      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* getClassDef () */

   public final void getClassItemCount
   (
         /*in*/   int            buf,
         /*out*/  IntegerBuffer  itemCount
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSGetClassItemCount(
         threadGroup,
         this.hdlContext,
         buf,
         itemCount);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



   public final void getClassItem
   (
         /*in*/   int            buf,
         /*out*/  StringBuffer   itemName
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSGetClassItem(
         threadGroup,
         this.hdlContext,
         buf,
         itemName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   public final void getObjectCount
   (
         /*in*/   int buf,
         /*out*/  NWInteger objectCount
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSGetObjectCount(
         threadGroup,
         this.hdlContext,
         buf,
         objectCount);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    *
    */
   public final void getObjectName (
         int buf,
         StringBuffer objectName,
         NWInteger attrCount,
         NetObjectInfo objectInfo)
      throws SessionException
   {
      int ccode;

      ccode = NetJNI.NWDSGetObjectName(
         threadGroup,
         this.hdlContext,
         buf,
         objectName,
         attrCount,
         objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* getObjectName () */


   public final void getSyntaxCount
   (
         /*in*/   int            buf,
         /*out*/  NWInteger      syntaxCount
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSGetSyntaxCount(
         threadGroup,
         this.hdlContext,
         buf,
         syntaxCount);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   public final void getSyntaxDef (
         int            buf,
         StringBuffer   syntaxName,
         NetSyntaxInfo  syntaxDef)
      throws SessionException
   {
      int ccode;

      ccode = NetJNI.NWDSGetSyntaxDef(
         threadGroup,
         this.hdlContext,
         buf,
         syntaxName,
         syntaxDef);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* getSyntaxDef () */

   /**
    *
    */
   public final void initBuf (
         int operation,
         int buf)
      throws SessionException
   {
      int ccode;

      if ((ccode = NetJNI.NWDSInitBuf (threadGroup, hdlContext,
            operation, buf)) != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* initBuf () */

   /**
    *
    */
   public final void list (
         String objectName,
         NetIterationHandle iterationHandle,
         NetListBuffer subordinates)
      throws SessionException
   {
      int ccode;

      ccode = NetJNI.NWDSList (
                        threadGroup,
                        this.hdlContext,
                        objectName,
                        iterationHandle,
                        subordinates.getBuffer ());

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* list () */

   /**
    *
    */
   public final void listContainers (
         String objectName,
         NetIterationHandle iterationHandle,
         NetListBuffer subordinates)
      throws SessionException
   {
      int ccode;

      ccode = NetJNI.NWDSListContainers (
                        threadGroup,
                        this.hdlContext,
                        objectName,
                        iterationHandle,
                        subordinates.getBuffer ());

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* listByClassAndName () */

   /**
    *
    */
   public final void listByClassAndName (
         String               objectName,
         String               className,
         String               subordinateName,
         NetIterationHandle   iterationHandle,
         NetListBuffer        subordinates)  //out
      throws SessionException
   {
      int ccode = NetJNI.NWDSListByClassAndName(
         threadGroup,
         this.hdlContext,
         objectName,
         className,
         subordinateName,
         iterationHandle,
         subordinates.getBuffer ());

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* listByClassAndName () */


   /**
    *
    */
   public final NetEntryInfo[] listEntries (
         String objectName,
         int bufferSize)
      throws SessionException
   {
      int ccode;
      NetEntryInfo[][] entries = new NetEntryInfo[1][];

      ccode = NetJNI.JDSListObjectEntries (
                                             threadGroup,
                                             this.hdlContext,
                                             BasicNetService.sNetEntryInfo,
                                             objectName,
                                             bufferSize,
                                             entries);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return (entries[0]);

   } /* listEntries () */


   public final void putChange
   (
         /*in*/   int            buf,
         /*out*/  int            changeType,
         /*out*/  String         attrName
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSPutChange(
         threadGroup,
         this.hdlContext,
         buf,
         changeType,
         attrName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   public final void putClassItem
   (
         /*in*/   int         buf,
         /*out*/  String      itemName
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSPutClassItem(
         threadGroup,
         this.hdlContext,
         buf,
         itemName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   public final void putFilter
   (
         /*in*/   int buf,
         /*in*/   int cur, // filter cursor
         /*in*/   int freeVal
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSPutFilter(
         threadGroup,
         this.hdlContext,
         buf,
         cur,
         freeVal);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    *
    */
   public final void putFilter (
         /*in*/   int buf,
         /*in*/   int cursor)
      throws SessionException
   {
      int ccode;

      ccode = NetJNI.JDSPutFilter (
                                       threadGroup,
                                       this.hdlContext,
                                       buf,
                                       cursor);
      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* putFilter () */


   /**
    *
    */
   public final void readObjectInfo (
         String         objectName,
         StringBuffer   distinguishedName,   // optional
         NetObjectInfo  objectInfo)         // optional
      throws SessionException
   {
      int ccode = NetJNI.NWDSReadObjectInfo(
         threadGroup,
         this.hdlContext,
         objectName,
         distinguishedName,
         objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* readObjectInfo () */

   public final void mapIDToName
   (
         /*in*/   int            objectID,
         /*out*/  StringBuffer   object
   )
   throws SessionException
   {
      Integer connection = (Integer)Natives.getContextInfo(
            nativeContext,
            Natives.DCK_LAST_CONNECTION);
      int hdlConnection = connection.intValue();

      int ccode = NetJNI.NWDSMapIDToName(
         threadGroup,
         this.hdlContext,
         hdlConnection,
         objectID,
         object);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   public final void mapNameToID
   (
         /*in*/   String         object,
         /*out*/  IntegerBuffer  objectID
   )
   throws SessionException
   {
      Integer connection = (Integer)Natives.getContextInfo(
            nativeContext,
            Natives.DCK_LAST_CONNECTION);
      int hdlConnection = connection.intValue();

      int ccode = NetJNI.NWDSMapNameToID(
         threadGroup,
         this.hdlContext,
         hdlConnection,
         object,
         objectID);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    *
    */
   public final void modifyObject (
         String objectName,
         NetIterationHandle iterationHandle,
         boolean more,
         int changes)
      throws SessionException
   {
      int ccode = NetJNI.NWDSModifyObject(
         threadGroup,
         this.hdlContext,
         objectName,
         iterationHandle,
         more,
         changes);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* modifyObject () */


 public final void modifyDN
 (
      String     objectName,
      String     newDN,
      boolean    deleteOldRDN

)
   throws SessionException
   {
      int ccode = NetJNI.NWDSModifyDN(
         threadGroup,
         this.hdlContext,
         objectName,
         newDN,
         deleteOldRDN);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


 public final void modifyRDN
 (
      String     objectName,
      String     newDN,
      boolean    deleteOldRDN

)
   throws SessionException
   {
      int ccode = NetJNI.NWDSModifyRDN(
         threadGroup,
         this.hdlContext,
         objectName,
         newDN,
         deleteOldRDN);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


 public final void moveObject
 (
      String     objectName,
      String     destParentDN,
      String     destRDN

)
   throws SessionException
   {
      int ccode = NetJNI.NWDSMoveObject(
         threadGroup,
         this.hdlContext,
         objectName,
         destParentDN,
         destRDN);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


 public final void openStream
 (
      String      objectName,
      String      attrName,
      int         flags,
      NWInteger   fileHandle
)
   throws SessionException
   {
      int ccode = NetJNI.NWDSOpenStream(
         threadGroup,
         this.hdlContext,
         objectName,
         attrName,
         flags,
         fileHandle);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    *
    */
   public final void read (
         String object,
         int infoType,
         boolean allAttrs,
         int attrNames,
         NetIterationHandle iterationHandle,
         int objectInfo)
      throws SessionException
   {
      int ccode = NetJNI.NWDSRead(
         threadGroup,
         this.hdlContext,
         object,
         infoType,
         allAttrs,
         attrNames,
         iterationHandle,
         objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build(ccode);
      }

   } /* read () */


   /**
    *
    */
   public NetAttrRecord[] readAttributes (
         /*in*/   String   objectName,
         /*in*/   int      infoType,
         /*in*/   int      attrNames,
         /*in*/   int      bufferSize)
      throws SessionException
   {
      int ccode;
      NetAttrRecord[][] records = new NetAttrRecord[1][];

      ccode = NetJNI.JDSReadObjectAttributes (
                           threadGroup,
                           this.hdlContext,
                           BasicNetService.sNetAttrRecord,
                           objectName,
                           infoType,
                           attrNames,
                           bufferSize,
                           records);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return (records[0]);

   } /* readAttributes () */


   /**
    *
    */
   public final void readAttrDef (
         int                     infoType,
         boolean                 allAttrs,
         int                     attrNames,
         NetIterationHandle      iterationHandle,
         NetReadAttrDefBuffer    attrDefs)
      throws SessionException
   {
      int ccode;

      ccode = NetJNI.NWDSReadAttrDef(
                        threadGroup,
                        this.hdlContext,
                        infoType,
                        allAttrs,
                        attrNames,
                        iterationHandle,
                        attrDefs.getBuffer ());

      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* readAttrDef () */


 public final void removeObject
 (
      String     object

)
   throws SessionException
   {
      int ccode = NetJNI.NWDSRemoveObject(
         threadGroup,
         this.hdlContext,
         object);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   public final void resolveName
   (
         /*in*/   String      objectName,
         /*out*/  NWInteger   conn,                   // optional
         /*out*/  NWInteger   objectID
   )              // optional
   throws SessionException
   {
      int ccode = NetJNI.NWDSResolveName(
         threadGroup,
         this.hdlContext,
         objectName,
         conn,
         objectID);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    *
    */
   public final void restoreObject (
         String objectName,
         NetIterationHandle iterationHandle,
         boolean more,
         int size,
         int objectInfo)
      throws SessionException
   {
      int ccode = NetJNI.NWDSRestoreObject(
         threadGroup,
         this.hdlContext,
         objectName,
         iterationHandle,
         more,
         size,
         objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* restoreObject () */

   /**
    *
    */
   public final void search (
         String      baseObjectName,
         int         scope,
         boolean     searchAliases,
         int         filter,    // a filter buffer.
         int         infoType,
         boolean     allAttrs,
         int         attrNames, // a buffer with the session attribute names.
         NetIterationHandle  iterationHandle,
         int         countObjectsToSearch,
         NWInteger   countObjectsSearched,
         int         objectInfo) // buffer to receive objects
      throws SessionException
   {
      int ccode = NetJNI.NWDSSearch(
         threadGroup,
         this.hdlContext,
         baseObjectName,
         scope,
         searchAliases,
         filter,    // a filter buf
         infoType,
         allAttrs,
         attrNames, // a buffer wit
         iterationHandle,
         countObjectsToSearch,
         countObjectsSearched,
         objectInfo); // buffer to re

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* search () */



 public final void auditGetObjectID
 (
      String         objectName,
      NWInteger      conn,
      NWInteger      objectID

)
   throws SessionException
   {
      int ccode = NetJNI.NWDSAuditGetObjectID(
         threadGroup,
         this.hdlContext,
         objectName,
         conn,
         objectID);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    *
    */
   public final void getEffectiveRights (
         /*in*/   String      subjectName,
         /*in*/   String      objectName,
         /*in*/   String      attrName,
         /*out*/  NWInteger   privileges)
      throws SessionException
   {
      int ccode;

      ccode = NetJNI.NWDSGetEffectiveRights(
                        threadGroup,
                        this.hdlContext,
                        subjectName,
                        objectName,
                        attrName,
                        privileges);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* getEffectiveRights () */


   /**
    *
    */
   public void listAttrsEffectiveRights (
         /*in*/      String               objectName,
         /*in*/      String               subjectName,
         /*in*/      boolean              allAttrs,
         /*in*/      int                  attrNames,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     int                  privilegeInfo)
      throws SessionException
   {
      int ccode;

      ccode = NetJNI.NWDSListAttrsEffectiveRights (
                        threadGroup,
                        this.hdlContext,
                        objectName,
                        subjectName,
                        allAttrs,
                        attrNames,
                        iterationHandle,
                        privilegeInfo);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /*  */

   /**
    *
    */
   public final void computeAttrValSize (
         int buf,
         int syntaxID,
         NWInteger attrValSize)
      throws SessionException
   {
      int ccode;

      ccode = NetJNI.NWDSComputeAttrValSize(
                        threadGroup,
                        this.hdlContext,
                        buf,
                        syntaxID,
                        attrValSize);
      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build(ccode);
      }

   } /* computeAttrValSize () */


   public final void abbreviateName
   (
         /*in*/   String         inName,
         /*out*/  StringBuffer   abbreviatedName
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSAbbreviateName(
         threadGroup,
         this.hdlContext,
         inName,
         abbreviatedName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    *
    */
   public final String removeAllTypes (
         String         name)
      throws SessionException
   {
      int ccode;
      StringBuffer typelessName = new StringBuffer (NetService.MAX_DN_CHARS);

      ccode = NetJNI.NWDSRemoveAllTypes (
         threadGroup,
         this.hdlContext,
         name,
         typelessName);

      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build (ccode);
      }
      return (new String (typelessName));

   } /* removeAllTypes () */


   public final void cIStringsMatch
   (
         /*in*/   String      string1,
         /*in*/   String      string2,
         /*out*/  NWBoolean   matches
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSCIStringsMatch(
         threadGroup,
         this.hdlContext,
         string1,
         string2,
         matches);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    *
    */
   public final void getAttrName (
         int buf,
         StringBuffer attrName,
         NWInteger attrValCount,           // optional
         NWInteger syntaxID)              // optional
      throws SessionException
   {
      int ccode = NetJNI.NWDSGetAttrName (
                              threadGroup,
                              this.hdlContext,
                              buf,
                              attrName,
                              attrValCount,
                              syntaxID);
      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build(ccode);
      }

   } /* getAttrName () */

   /**
    *    @deprecated    use getAttributeValue() instead
    */
   public final void getAttrVal (
         int         buf,
         int         syntaxID,
         NetMemory   attrVal)
      throws SessionException
   {
      int ccode = NetJNI.NWDSGetAttrVal(
         threadGroup,
         this.hdlContext,
         buf,
         syntaxID,
         attrVal);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* getAttrVal () */


   /**
    *
    */
   public final byte[] getAttributeValue (
         int         buf,
         int         syntaxID)
      throws SessionException
   {
      byte[][] attributeValue = new byte[1][];

      int ccode = NetJNI.JDSGetAttributeValue (
                                                   threadGroup,
                                                   this.hdlContext,
                                                   buf,
                                                   syntaxID,
                                                   attributeValue);
      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return (attributeValue[0]);

   } /* getAttributeValue () */


 public final void putAttrName
 (
      int         buf,
      String      attrName

)
   throws SessionException
   {
      int ccode = NetJNI.NWDSPutAttrName(
         threadGroup,
         this.hdlContext,
         buf,
         attrName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   /**
    *    @deprecated    use getAttributeValue() instead
    */
   public final void putAttrVal (
         int         buf,
         int         syntaxID,
         int         attrVal)
      throws SessionException
   {
      int ccode = NetJNI.NWDSPutAttrVal(
         threadGroup,
         this.hdlContext,
         buf,
         syntaxID,
         attrVal);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   /**
    *
    */
   public final void putAttributeValue (
         int                              buf,
         int                              syntaxID,
         byte[]                           attributeValue)
      throws SessionException
   {
      int ccode = NetJNI.JDSPutAttributeValue (
                                                   threadGroup,
                                                   this.hdlContext,
                                                   buf,
                                                   syntaxID,
                                                   attributeValue);
      if (0 != ccode)
      {
         throw ( NSIExceptionBuilder.build(ccode));
      }

   } /* putAttributeValue () */


 public final void getSyntaxID
 (
      String      attrName,
      NWInteger   syntaxID

)
   throws SessionException
   {
      int[] temp = new int[1];
      int ccode = NetJNI.NWDSGetSyntaxID(
         threadGroup,
         this.hdlContext,
         attrName,
         temp);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      syntaxID.setValue(temp[0]);
   }


 public final void replaceAttrNameAbbrev
 (
      String         inStr,
      StringBuffer   outStr

)
   throws SessionException
   {
      int ccode = NetJNI.NWDSReplaceAttrNameAbbrev(
         threadGroup,
         this.hdlContext,
         inStr,
         outStr);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    *
    */
   public final void extSyncList (
         String               objectName,
         String               className,
         String               subordinateName,
         NetIterationHandle   iterationHandle,
         int                  timeStamp,
         boolean              onlyContainers,
         NetListBuffer        subordinates)  //out
      throws SessionException
   {
      int ccode = NetJNI.NWDSExtSyncList(
         threadGroup,
         this.hdlContext,
         objectName,
         className,
         subordinateName,
         iterationHandle,
         timeStamp,
         onlyContainers,
         subordinates.getBuffer ());

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* extSyncList () */

   /**
    *
    */
   public final void extSyncRead (
         String      objectName,
         int         infoType,
         boolean     allAttrs,
         int         attrNames,        //in, the request buffer
         NetIterationHandle  iterationHandle,   //in-out
         NetBuffer  objectInfo)         //out, the request buffer
      throws SessionException
   {
      int ccode = NetJNI.NWDSExtSyncRead(
         threadGroup,
         this.hdlContext,
         objectName,
         infoType,
         allAttrs,
         attrNames,
         iterationHandle,
         objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* extSyncRead () */

   /**
    *
    */
   public final void extSyncSearch (
         String      baseObjectName,
         int         scope,
         boolean     searchAliases,
         int         filter,    //a filter buffer.
//         NDSTimeStamp timeStamp,
         int         infoType,
         boolean     allAttrs,
         int         attrNames, //a buffer with the session attribute names.
         NetIterationHandle  iterationHandle,
         int         countObjectsToSearch,
         NWInteger   countObjectsSearched,
         NetBuffer   objectInfo)
      throws SessionException
   {
      int ccode = NetJNI.NWDSExtSyncSearch(
         threadGroup,
         this.hdlContext,
         baseObjectName,
         scope,
         searchAliases,
         filter,    //a filter buffe
         infoType,
         allAttrs,
         attrNames, //a buffer with
         iterationHandle,
         countObjectsToSearch,
         countObjectsSearched,
         objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* extSyncSearch () */


   /**
    *
    */
   public final void readClassDef (
         int                     infoType,
         boolean                 allClasses,
         int                     classNames,
         NetIterationHandle      iterationHandle,
         NetReadClassDefBuffer   classDefs)
      throws SessionException
   {
      int ccode;

      ccode = NetJNI.NWDSReadClassDef (
                        threadGroup,
                        this.hdlContext,
                        infoType,
                        allClasses,
                        classNames,
                        iterationHandle,
                        classDefs.getBuffer ());

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* readClassDef () */


   /**
    *
    */
   public final void defineAttr (
         String            attrName,
         NetAttributeInfo  attrDef)
      throws SessionException
   {
      int ccode = NetJNI.NWDSDefineAttr(
         threadGroup,
         this.hdlContext,
         attrName,
         attrDef);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* defineAttr () */

   /**
    *
    */
   public final void defineClass (
         String         className,
         NetClassInfo   classInfo,
         int            classItems)
      throws SessionException
   {
      int ccode = NetJNI.NWDSDefineClass(
         threadGroup,
         this.hdlContext,
         className,
         classInfo,
         classItems);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* defineClass () */


 public final void removeClassDef
 (
         /*in*/   String         className
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSRemoveClassDef(
         threadGroup,
         this.hdlContext,
         className);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

/* unused
 public final void ListContainableClasses
 (
         /*in* /      int                  hdlContext,
         /*in* /      String               parentObject,
         /*in/out* /  NetIterationHandle   iterationHandle,
         /*out* /     NetBufferHandle      containableClasses
   )
*/

 public final void modifyClassDef
 (
         /*in*/   String         className,
         /*in*/   int            optionalAttrs
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSModifyClassDef(
         threadGroup,
         this.hdlContext,
         className,
         optionalAttrs);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    *
    */
   public final void readSyntaxes (
         int infoType,
         boolean allSyntaxes,
         int syntaxNames,
         NetIterationHandle iterationHandle,
         int syntaxDefs)
      throws SessionException
   {
      int ccode = NetJNI.NWDSReadSyntaxes(
         threadGroup,
         this.hdlContext,
         infoType,
         allSyntaxes,
         syntaxNames,
         iterationHandle,
         syntaxDefs);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* readSyntaxes () */


 public final void removeAttrDef
 (
         /*in*/   String         attrName
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSRemoveAttrDef(
         threadGroup,
         this.hdlContext,
         attrName);
      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


 public final void putSyntaxName
 (
         /*in*/   int            buf,
         /*in*/   String         syntaxName
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSPutSyntaxName(
         threadGroup,
         this.hdlContext,
         buf,
         syntaxName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


 public final void putClassName
 (
         /*in*/   int            buf,
         /*in*/   String         itemName
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSPutClassName(
         threadGroup,
         this.hdlContext,
         buf,
         itemName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    *
    */
   public final void readSyntaxDef (
         int syntaxID,
         NetSyntaxInfo syntaxDef)
      throws SessionException
   {
      int ccode = NetJNI.NWDSReadSyntaxDef(
         threadGroup,
         this.hdlContext,
         syntaxID,
         syntaxDef);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build(ccode);
      }

   } /* readSyntaxDef () */


   public final void syncSchema
   (
         /*in*/   String         server,
         /*in*/   int            seconds
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSSyncSchema(
         threadGroup,
         this.hdlContext,
         server,
         seconds);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   // ******************** Partition methods ********************

   public final void abortPartitionOperation
   (
      /*in*/   String         partitionRoot
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSAbortPartitionOperation(
         threadGroup,
         this.hdlContext,
         partitionRoot);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   /**
    *
    */
   public final void addPartition (
         String server,
         String partitionRoot,
         NetIterationHandle iterationHandle,
         boolean more,
         int objectInfo)
      throws SessionException
   {
      int ccode = NetJNI.NWDSAddPartition(
         threadGroup,
         this.hdlContext,
         server,
         partitionRoot,
         iterationHandle,
         more,
         objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* addPartition () */



   public final void addReplica
   (
      /*in*/      String         server,
      /*in*/      String         partitionRoot,
      /*in*/      int            replicaType
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSAddReplica(
         threadGroup,
         this.hdlContext,
         server,
         partitionRoot,
         replicaType);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   public final void changeReplicaType
   (
      /*in*/      String         replicaName,
      /*in*/      String         server,
      /*in*/      int            newReplicaType
)
   throws SessionException
   {
      int ccode = NetJNI.NWDSChangeReplicaType(
         threadGroup,
         this.hdlContext,
         replicaName,
         server,
         newReplicaType);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   /**
    *
    */
   public final void getPartitionExtInfo (
         int infoPtr,
         int limit,
         int infoFlag,
         IntegerBuffer length,   /* this is different than the C API */
         NetPartitionExtInfo data)    /* this is different than the C API */
      throws SessionException
   {
      int ccode = NetJNI.NWDSGetPartitionExtInfo(
         threadGroup,
         this.hdlContext,
         infoPtr,
         limit,
         infoFlag,
         length,
         data);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build(ccode);
      }

   } /* getPartitionExtInfo () */

   public final void getPartitionExtInfoPtr
   (
      /*in*/      int            buf,
      /*out*/     IntegerBuffer  infoPtr,       /* this is different than the C API */
      /*out*/     IntegerBuffer  infoPtrEnd
)   /* this is different than the C API */
   throws SessionException
   {
      int ccode = NetJNI.NWDSGetPartitionExtInfoPtr(
         threadGroup,
         this.hdlContext,
         buf,
         infoPtr,
         infoPtrEnd);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   public final void getPartitionInfo
   (
      /*in*/      int            buf,
      /*out*/     StringBuffer   partitionName,
      /*out*/     IntegerBuffer  replicaType
)
   throws SessionException
   {
      int ccode = NetJNI.NWDSGetPartitionInfo(
         threadGroup,
         this.hdlContext,
         buf,
         partitionName,
         replicaType);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



   public final void getPartitionRoot
   (
      /*in*/   String         objectName,
      /*out*/  StringBuffer   partitionRoot
)
   throws SessionException
   {
      int ccode = NetJNI.NWDSGetPartitionRoot(
         threadGroup,
         this.hdlContext,
         objectName,
         partitionRoot);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



   public final void getServerName
   (
      /*in*/      int            buf,
      /*out*/     StringBuffer   serverName,
      /*out*/     IntegerBuffer  partitionCount
)
   throws SessionException
   {
      int ccode = NetJNI.NWDSGetServerName(
         threadGroup,
         this.hdlContext,
         buf,
         serverName,
         partitionCount);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



   public final void joinPartitions
   (
      /*in*/   String         subordinatePartition,
      /*in*/   int            flags
)
   throws SessionException
   {
      int ccode = NetJNI.NWDSJoinPartitions(
         threadGroup,
         this.hdlContext,
         subordinatePartition,
         flags);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   /**
    *
    */
   public final void listPartitions (
         NetIterationHandle iterationHandle,
         String server,
         int partitions)
      throws SessionException
   {
      int ccode = NetJNI.NWDSListPartitions(
         threadGroup,
         this.hdlContext,
         iterationHandle,
         server,
         partitions);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* listPartitions () */

   /**
    *
    */
   public final void listPartitionsExtInfo (
         NetIterationHandle iterationHandle,
         String server,
         int DSPFlags,
         int partitions)
      throws SessionException
   {
      int ccode = NetJNI.NWDSListPartitionsExtInfo(
         threadGroup,
         this.hdlContext,
         iterationHandle,
         server,
         DSPFlags,
         partitions);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* listPartitionsExtInfo () */



   public final void partitionReceiveAllUpdates
   (
      /*in*/      String         partitionRoot,
      /*in*/      String         serverName
)
   throws SessionException
   {
      int ccode = NetJNI.NWDSPartitionReceiveAllUpdates(
         threadGroup,
         this.hdlContext,
         partitionRoot,
         serverName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



   public final void partitionSendAllUpdates
   (
      /*in*/      String         partitionRoot,
      /*in*/      String         serverName
)
   throws SessionException
   {
      int ccode = NetJNI.NWDSPartitionSendAllUpdates(
         threadGroup,
         this.hdlContext,
         partitionRoot,
         serverName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



   public final void removePartition
   (
      /*in*/      String         partitionRoot
)
   throws SessionException
   {
      int ccode = NetJNI.NWDSRemovePartition(
         threadGroup,
         this.hdlContext,
         partitionRoot);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



   public final void removeReplica
   (
      /*in*/      String         server,
      /*in*/      String         partitionRoot
)
   throws SessionException
   {
      int ccode = NetJNI.NWDSRemoveReplica(
         threadGroup,
         this.hdlContext,
         server,
         partitionRoot);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



   public final void splitPartition
   (
      /*in*/   String         subordinatePartition,
      /*in*/   int            flags
)
   throws SessionException
   {
      int ccode = NetJNI.NWDSSplitPartition(
         threadGroup,
         this.hdlContext,
         subordinatePartition,
         flags);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



   public final void syncPartition
   (
      /*in*/      String         server,
      /*in*/      String         partition,
      /*in*/      int            seconds
)
   throws SessionException
   {
      int ccode = NetJNI.NWDSSyncPartition(
         threadGroup,
         this.hdlContext,
         server,
         partition,
         seconds);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



   public final void syncReplicaToServer
   (
      /*in*/      String         serverName,
      /*in*/      String         partitionRootName,
      /*in*/      String         destServerName,
      /*in*/      int            actionFlags,
      /*in*/      int            delaySeconds
)
   throws SessionException
   {
      int ccode = NetJNI.NWDSSyncReplicaToServer(
         threadGroup,
         this.hdlContext,
         serverName,
         partitionRootName,
         destServerName,
         actionFlags,
         delaySeconds);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



    // ******************** Nds server methods ********************
/*
   public final void openConnToNDSServer
   (
      in      String         serverName,
      out     IntegerBuffer  connHandle
   )
   throws SessionException
   {
      int ccode = NetJNI.NWDSOpenConnToNDSServer(
         threadGroup,
         this.hdlContext,
         serverName,
         connHandle);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
*/

   public final void getServerAddresses
   (
      /*out*/     IntegerBuffer  countNetAddresses,
      /*out*/     int            netAddresses
)
   throws SessionException
   {
      Integer connection = (Integer)Natives.getContextInfo(
            nativeContext,
            Natives.DCK_LAST_CONNECTION);
      int hdlConnection = connection.intValue();

      int ccode = NetJNI.NWDSGetServerAddresses(
         threadGroup,
         this.hdlContext,
         hdlConnection,
         countNetAddresses,
         netAddresses);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



   // ******************** Object Info methods ********************

   /**
    *    @deprecated    use readEntry() instead
    */
   public final void readObjectDSIInfo (
         String object,
         NetMemory objectInfo)
      throws SessionException
   {
      int ccode = NetJNI.NWDSReadObjectDSIInfo(
         threadGroup,
         this.hdlContext,
         object,
         objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* ReadObjectDSIInfo () */

   /**
    *    @deprecated    use readEntry() instead
    */
   public final void getDSIInfo (
         NetMemory   buf,
         int         infoFlag,
         NetMemory   data)
      throws SessionException
   {
      int ccode = NetJNI.NWDSGetDSIInfo(
         threadGroup,
         this.hdlContext,
         buf,
         infoFlag,
         data);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* getDSIInfo () */


   /**
    *
    */
   public final NetEntryInfo readEntry (
         /*in*/   String                  object,
         /*in*/   int                     bufferSize)
      throws SessionException
   {
      int ccode;
      NetEntryInfo[] entry = new NetEntryInfo[1];

      ccode = NetJNI.JDSReadObjectEntry (
                                             threadGroup,
                                             this.hdlContext,
                                             BasicNetService.sNetEntryInfo,
                                             object,
                                             bufferSize,
                                             entry);
      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return (entry[0]);

   } /* readObjectEntry () */


   public final void getNWNetVersion(
      /*out*/  IntegerBuffer   majorVersion,
      /*out*/  IntegerBuffer   minorVersion,
      /*out*/  IntegerBuffer   revisionLevel,
      /*out*/  IntegerBuffer   betaReleaseLevel)
      throws SessionException
   {
      NetJNI.NWGetNWNetVersion(
         majorVersion, minorVersion, revisionLevel, betaReleaseLevel);
   }

   /**
    *
    */
   public final int getFileServerUTCTime ()
      throws SessionException
   {
      int ccode;
      IntegerBuffer  time = new IntegerBuffer ();

      Integer connection = (Integer)Natives.getContextInfo(
            nativeContext,
            Natives.DCK_LAST_CONNECTION);
      int hdlConnection = connection.intValue();

      ccode = NetJNI.NWGetFileServerUTCTime (hdlConnection, time);

      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build(ccode);
      }

      return (time.intValue ());

   } /* getFileServerUTCTime () */

   /**
    *
    */
   public void reloadDS (
         /*in*/      String serverName)
      throws SessionException
   {
      int ccode;

      ccode = NetJNI.NWDSReloadDS (threadGroup, hdlContext, serverName);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }
   }


   // ******************** nwitr.h ********************

   /**
    *
    */
   public void itrCreateSearch (
         /*in*/   String   baseObjectName,
         /*in*/   int      scope,
         /*in*/   boolean  searchAliases,
         /*in*/   int      filter,      // a filter buffer
         /*in*/   int      timeFilter,
         /*in*/   int      infoType,
         /*in*/   boolean  allAttrs,
         /*in*/   int      attrNames,   // a buffer with the attribute names
         /*in*/   String   indexSelect,
         /*in*/   String   sortKey,
         /*in*/   int      scalability,
         /*in*/   int      timeout,
         /*out*/  int[]    iterator)
      throws SessionException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrCreateSearch (
                                       threadGroup,
                                       this.hdlContext,
                                       baseObjectName,
                                       scope,
                                       searchAliases,
                                       filter,
                                       timeFilter,
                                       infoType,
                                       allAttrs,
                                       attrNames,
                                       indexSelect,
                                       sortKey,
                                       scalability,
                                       timeout,
                                       iterator);
      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* itrCreateSearch () */

   /**
    *
    */
   public void itrCreateList (
         /*in*/   String   baseObjectName,
         /*in*/   String   className,
         /*in*/   String   subordinateName,
         /*in*/   int      scalability,
         /*in*/   int      timeout,
         /*out*/  int[]    iterator)
      throws SessionException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrCreateList (
                                       threadGroup,
                                       this.hdlContext,
                                       baseObjectName,
                                       className,
                                       subordinateName,
                                       scalability,
                                       timeout,
                                       iterator);
      if (0 != ccode)
      {
            throw (NSIExceptionBuilder.build (ccode));
      }

   } /* itrCreateList () */

   /**
    *
    */
   public void itrDestroy (
         /*in*/   int iterator)
      throws SessionException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrDestroy (iterator);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* itrDestroy () */

   /**
    *
    */
   public void itrClone (
         /*in*/   int      iterator,
         /*out*/  int[]    newIterator)
      throws SessionException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrClone (iterator, newIterator);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* itrClone () */


   /**
    *
    */
   public boolean itrAtFirst (
         /*in*/   int   iterator)
      throws SessionException
   {
      return (NetJNI.NWDSItrAtFirst (iterator));
   }

   /**
    *
    */
   public boolean itrAtEOF (
         /*in*/   int   iterator)
      throws SessionException
   {
      return (NetJNI.NWDSItrAtEOF (iterator));
   }

   /**
    *
    */
   public void itrGetInfo (
         /*in*/   int   iterator,
         /*out*/  boolean[] isScalable,
         /*out*/  boolean[] isPositionable)
      throws SessionException
   {
      int ccode;

      ccode = NetJNI.NWDSItrGetInfo (
                                       iterator,
                                       isScalable,
                                       isPositionable);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* itrGetInfo () */


   /**
    *
    */
   public void itrGetPosition (
         /*in*/   int      iterator,
         /*out*/  int[]    position,
         /*in*/   int      timeout)
      throws SessionException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrGetPosition (iterator, position, timeout);

      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* itrGetPosition () */

   /**
    *
    */
   public void itrSetPosition (
         /*in*/   int   iterator,
         /*in*/   int   position,
         /*in*/   int   timeout)
      throws SessionException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrSetPosition (iterator, position, timeout);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* itrSetPosition () */

   /**
    *
    */
   public void itrSetPositionFromIterator (
         /*in*/   int   iterator,
         /*in*/   int   srcIterator,
         /*in*/   int   timeout)
      throws SessionException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrSetPositionFromIterator (
                                                         iterator,
                                                         srcIterator,
                                                         timeout);

      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* itrSetPositionFromIterator () */

   /**
    *
    */
   public void itrTypeDown (
         /*in*/   int      iterator,
         /*in*/   String   attribute,
         /*in*/   String   value,
         /*in*/   int      timeout)
      throws SessionException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrTypeDown (
                                          iterator,
                                          attribute,
                                          value,
                                          timeout);
      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* itrTypeDown () */

   /**
    *
    */
   public void itrSkip (
         /*in*/   int      iterator,
         /*in*/   int      numToSkip,
         /*in*/   int      timeout,
         /*out*/  int[]    numSkipped)
      throws SessionException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrSkip (iterator, numToSkip, timeout, numSkipped);

      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* itrSkip () */

   /**
    *
    */
   public void itrGetNext (
         /*in*/      int                  iterator,
         /*in*/      int                  numEntries,
         /*in*/      int                  timeout,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     int                  data)
      throws SessionException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrGetNext (
                                       iterator,
                                       numEntries,
                                       timeout,
                                       iterationHandle,
                                       data);
      if (0 != ccode)
      {
		if((iterationHandle.getValue()==NetIterationHandle.NO_MORE_ITERATIONS)&&(ccode==NetJNI.ERR_EOF_HIT))
		{
			// doing nothing; See defect000331963
		}
		else 
		{         
			throw NSIExceptionBuilder.build (ccode);
		}
	  }

   } /*  */

   /**
    *
    */
   public void itrGetPrev (
         /*in*/      int                  iterator,
         /*in*/      int                  numEntries,
         /*in*/      int                  timeout,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     int                  data)
      throws SessionException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrGetPrev (
                                       iterator,
                                       numEntries,
                                       timeout,
                                       iterationHandle,
                                       data);
      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* itrGetPrev () */

   /**
    *
    */
   public void itrGetCurrent (
      /*in*/      int                  iterator,
      /*in/out*/  NetIterationHandle   iterationHandle,
      /*out*/      int                  data)
      throws SessionException, NSIException
   {
      int ccode = NetJNI.NWDSItrGetCurrent (
         iterator,
         iterationHandle,
         data);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* itrGetCurrent () */

   /**
    *
    */
   public void itrCount (
         /*in*/   int         iterator,
         /*in*/   int         timeout,
         /*in*/   int         maxCount,
         /*in*/   boolean     updatePosition,
         /*out*/  int[]       count)
      throws SessionException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrCount (
                                       iterator,
                                       timeout,
                                       maxCount,
                                       updatePosition,
                                       count);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* itrCount () */

} /* BasicNetService */


