/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/jncpv2/net/NetIterationHandle.java $
  $Revision: 7 $
  $Modtime: 8/21/01 4:59p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.jncpv2.net;

import java.io.Serializable;
import com.novell.service.jncp.NSIException;
import com.novell.service.session.SessionException;

/**
 * Represents an NWNET iteration handle.
 *
 * <p>NetIterationHandle is a low-level class. Developers will not use this
 * class.
 * <p>This will clean itself up by calling NWDSCloseIteration if the
 * user didn't exhaust the iteration handle.
 * </p>
 */
public final class NetIterationHandle implements Serializable
{
   /**
    *
    */
   public final static int  NO_MORE_ITERATIONS       = 0xFFFFFFFF;

   private NetService service;
   private int operation;
   private int handle;

   /**
    * NetIterationHandle.
    *
    * Create an NetIterationHandle that is set to NO_MORE_ITERATIONS.
    *
    * @param operation  One of the following:
    *    <p>DSV_READ                      NWDSExtSyncRead
    *                                     NWDSListAttrsEffectiveRights
    *                                     NWDSReadNWDSReadReferences
    *    <p>DSV_COMPARE	                  NWDSCompare
    *    <p>DSV_SEARCH	                  NWDSExtSyncList
    *                                     NWDSExtSyncSearch
    *                                     NWDSListByClassAndName
    *                                     NWDSListContainers
    *                                     NWDSPutFilter
    *                                     NWDSSearch
    *    <p>DSV_ADD_ENTRY                 NWDSAddObject
    *    <p>DSV_MODIFY_ENTRY              NWDSModifyObject
    *    <p>DSV_READ_ATTR_DEF             NWDSReadAttrDef
    *    <p>DSV_DEFINE_CLASS              NWDSDefineClass
    *    <p>DSV_READ_CLASS_DEF            NWDSReadClassDef
    *    <p>DSV_MODIFY_CLASS_DEF          NWDSModifyClassDef
    *    <p>DSV_LIST_CONTAINABLE_CLASSES  NWDSListContainableClasses
    *    <p>DSV_ADD_PARTITION             NWDSAddPartition
    *    <p>DSV_LIST_PARTITIONS           NWDSListPartitions
    *    <p>DSV_BACKUP_ENTRY              NWDSBackupObject
    *    <p>DSV_RESTORE_ENTRY             NWDSRestoreObject
	*    <p>DSV_ITERATOR                  NWDSItrGetCurrent
	*                                     NWDSItrGetNext
	*                                     NWDSItrGetPrev
    */
   public NetIterationHandle (
         NetService service,
         int operation)
   {
      this.service = service;
      this.operation = operation;
      handle = NO_MORE_ITERATIONS;

   } /* NetIterationHandle () */


   /**@internal
    * Releases resources used by iteration handle.
    * Only release if we havn't gone through all iterations
    */
   public void finalize ()
      throws SessionException
   {
      try
      {
         if (moreIterations ())
         {
            service.closeIteration (handle, operation);
         }
      }
      catch (SessionException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }

   }


	/**@internal
	 * Releases resources used by iteration handle.
	 * May be called when a NamingEnumeration is closed.
	 */
	public void closeIteration ()
	   throws NSIException
	{
		try
		{
         if (moreIterations ())
         {
            service.closeIteration (handle, operation);
			handle = NO_MORE_ITERATIONS;
         }
		}
		catch (SessionException e)
		{
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
		}
	}

	
   /**
    * setValue.
    *
    * Sets the NetIterationHandle to value.
    * </p>
    */
   public void setValue (
      int handle)
   {
      this.handle = handle;

   } /* setValue () */

   /**
    * getValue.
    *
    * Returns the NetIterationHandle value.
    * </p>
    */
   public int getValue ()
   {
      return (handle);
   }

   /**
    *
    */
   public boolean moreIterations ()
   {
      return (handle != NO_MORE_ITERATIONS);
   }

}  /* NetIterationHandle */


