
/* **************************************************************************

  %name: NetReadAttrDefBuffer.java %
  %version: 11 %
  %date_modified: Fri Feb 13 15:09:40 1998 %

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.jncpv2.net;


import java.io.Serializable;
import java.io.IOException;

import java.util.Enumeration;
import java.util.NoSuchElementException;

import com.novell.java.io.EndianInputStream;

import com.novell.service.jncp.NSIException;


/** @internal
 *
 */
public final class NetReadAttrDefBuffer implements Serializable
{
   private int type;
   private byte[] buffer;

   /**
    *
    */
   public NetReadAttrDefBuffer (
         NetService service,
         int type)
   {
      this (service, type, NetJNI.DEFAULT_MESSAGE_LEN);
   }

   /**
    *
    */
   public NetReadAttrDefBuffer (
         NetService service,
         int type,
         int size)
   {
      this.type = type;
      buffer = new byte[size];
   }

   /**
    * Returns the buffer used for native calls.
    *
    * @return                    The buffer used for native calls.
    */
   byte[] getBuffer ()
   {
      return (buffer);
   }

   /**
    *
    */
   public Enumeration getEntries ()
      throws NSIException
   {
      return (new EntryEnumerator ());
   }

   /** @internal
    *
    */
   class EntryEnumerator implements Enumeration
   {
      private int entriesLeft;
      private EndianInputStream eisEntries;

      protected EntryEnumerator ()
         throws NSIException
      {
         try
         {
            eisEntries = new EndianInputStream (buffer);
            entriesLeft = eisEntries.readLoHiInt ();
         }
         catch (IOException e)
         {
            throw (new NSIException ());
         }

      }

      public boolean hasMoreElements ()
      {
         if (entriesLeft == 0)
         {
            return (false);
         }
         return (true);
      }

      public Object nextElement ()
      {
         if (!this.hasMoreElements ())
         {
            throw (new NoSuchElementException ());
         }
         entriesLeft--;
         return (new NetAttrInfo (eisEntries, type));
      }

   } /* EntryEnumerator */

} /* NetReadAttrDefBuffer */


