/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/ncpext/NCPExtensionObjectFactory.java $
  $Revision: 7 $
  $Modtime: 6/27/03 9:21a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.ncpext;

import com.novell.service.session.*;
import com.novell.utility.naming.Environment;
import com.novell.utility.naming.URLParser;
import javax.naming.spi.*;
import javax.naming.*;
import java.util.*;

/** @internal
* Creates an NCPExtensionInitialDirContext or NCPExtensionDirContext
*/
public class NCPExtensionObjectFactory implements ObjectFactory
{
   /**
   * @param obj                  Should be a reference containing a
   *                             StringRefAddr with Context.PROVIDER_URL as
   *                             addrType that specifies the server. If obj
   *                             also contains a StringRefAddr with
   *                             NCPExtensionStrings.NCPEXT_NAME as
   *                             the type create a NCPExtensionDirContext,
   *                             otherwise create an
   *                             NCPExtensionInitialDirContext
   * @param hash                 Properties for the context. Will be cloned
   * @return                     The object created or null
   * @exception Exception        never actually thrown
   */
   public Object getObjectInstance(
         Object obj,
         Name name,  //NOTE: name needs to be implemented
         Context nameCtx,  //NOTE: name needs to be implemented
         Hashtable hash)
      throws Exception
   {
      //This is stupid to return null and throw away vital information about why
      //the object factory could not create the object. JNDI spec needs to be fixed.
      //try  REMOVED. see note above.
      {
         if(hash == null)
            hash = new Hashtable();
         StringRefAddr host =
            (StringRefAddr)((Reference)obj).get(Context.PROVIDER_URL);
         StringRefAddr extension =
            (StringRefAddr)((Reference)obj).get(NCPExtensionStrings.NCPEXT_NAME);
			String url = (String)host.getContent();
         String serverName = new URLParser (url).getHost ();

         Hashtable h = (Hashtable)hash.clone();  //Cant just change the parents
         h.put(Context.PROVIDER_URL, serverName);

         SessionManager sm = (SessionManager)h.get(
            com.novell.utility.naming.Environment.SESSION_MANAGER_OBJECT);
         if(sm == null)
         {
            SessionEnv env = new SessionEnv();
            env.put(SessionEnv.INITIAL_SESSION_FACTORY,
               "com.novell.service.session.nds.NDSInitialSessionFactory:" +
               "com.novell.service.session.bindery.BinderyInitialSessionFactory");
            sm = SessionManagerFactory.getSessionManager(env);
            h.put(com.novell.utility.naming.Environment.SESSION_MANAGER_OBJECT, sm);
         }

         Session session = sm.getSessionTop(serverName);
         h.put(com.novell.utility.naming.Environment.SESSION_OBJECT, session);

         if(null == extension)
            return new NCPExtensionInitialDirContext(h);
         else
         {
            h.put(NCPExtensionStrings.NCPEXT_NAME, extension.getContent());
            return new NCPExtensionDirContext(h);
         }
      }
      //catch(Exception e)
      //{
      //   return null;
      //}
   }
}
