
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/NdsIteratorResult.java $
  $Revision: 9 $
  $Modtime: 2/02/00 9:28a $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds;


import java.io.Serializable;

import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;

import com.novell.service.nds.NdsObjectInfo;


/**
 * Represents an item in the NamingEnumeration returned as a
 * result of calls to the NdsIterator.next() or NdsIterator.previous()
 * methods.
 *
 * <p>An NdsIteratorResult instance is not synchronized against 
 * concurrent multithreaded access. Multiple threads trying to
 * access and modify a single NdsIteratorResult instance should
 * lock the object.
 *
 * @see NdsIterator#next
 * @see NdsIterator#previous
 */
public final class NdsIteratorResult
   extends SearchResult
   implements Serializable
{
   /**
    * Contains the NDS information returned with the object.
    * @serial
    */
   private NdsObjectInfo info;

   /**
    * Constructs an NdsIteratorResult instance using the result's name,
    * its bound object, its attributes, and its NDS object information.
    *
    * <p>The javax.naming.NameClassPair.getClassName() method will return
    * the class name of obj (or NULL if obj is NULL), unless the class name
    * has been explicitly set using the javax.naming.NameClassPair.setClassName()
    * method. 
    *
    * @param name  The non-NULL name of the iterator item. It is
    *              relative to the target context of the iterator, 
    *              which is named by the first parameter of the 
    *              next() or previous() methods.
    * @param obj   The object bound to name.
    *              Can be NULL.
    * @param attrs The attributes that were requested to be returned 
    *              with this iterator item. Cannot be NULL.
    * @param info  The NDS object information about this iterator item.
    *              Cannot be NULL.
    */
   public NdsIteratorResult (
         String name,
         Object obj,
         Attributes attrs,
         NdsObjectInfo info)
   {
      super (name, obj, attrs);

      this.info = info;
   }

   /**
    * Constructs an NdsIteratorResult instance using the result's name,
    * its bound object, its attributes, its NDS object information, and
    * a boolean indicating whether or not the name is relative.
    *
    * <p>The javax.naming.NameClassPair.getClassName() method will return
    * the class name of obj (or NULL if obj is NULL) unless the class name
    * has been explicitly set using the javax.naming.NameClassPair.setClassName()
    * method. 
    *
    * @param name  The non-NULL name of the iterator item.
    * @param obj   The object bound to name. Can be NULL. 
    * @param attrs The attributes that were requested to be returned 
    *              with this iterator item. Cannot be NULL.
    * @param info  The NDS information about this iterator item.
    *              Cannot be NULL.
    * @param isRelative A boolean set to TRUE if name is relative to 
    *                   the target context of the iterator, which is
    *                   named by the first parameter of the 
    *                   createIterator() method; otherwise, set to 
    *                   FALSE if name is a URL string.
    */
   public NdsIteratorResult (
         String name,
         Object obj,
         Attributes attrs, 
         NdsObjectInfo info,
         boolean isRelative)
   {
      super (name, obj, attrs, isRelative);

      this.info = info;
   }

   /**
    * Constructs an NdsIteratorResult instance using the result's name,
    * its class name, its bound object, its attributes, and its NDS
    * object information.
    *
    * <p>The javax.naming.NameClassPair.getClassName() method will return
    * the class name of obj (or NULL if obj is NULL) unless the class name
    * has been explicitly set using the javax.naming.NameClassPair.setClassName()
    * method. 
    *
    * @param name  The non-NULL name of the iterator item. It is
    *              relative to the target context of the iterator, 
    *              which is named by the first parameter of the 
    *              next() or previous() methods.
    * @param className  The class name of the object bound to name. 
    *                   If NULL, the class name of obj is returned by 
    *                   the getClassName() method. If obj is also NULL, 
    *                   the getClassName()method will return NULL.
    * @param obj   The object bound to name. Can be NULL.
    * @param attrs The attributes that were requested to be returned 
    *              with this iterator item. Cannot be NULL.
    * @param info  The NDS object information about this iterator item.
    *              Cannot be NULL.
    */
   public NdsIteratorResult (
         String name,
         String className, 
         Object obj,
         Attributes attrs,
         NdsObjectInfo info)
   {
      super (name, className, obj, attrs);

      this.info = info;
   }

   /**
    * Constructs an NdsIteratorResult instance using the result's name,
    * its class name, its bound object, its attributes, its NDS object
    * information, and a boolean indicating whether or not the name is
    * relative.
    *
    * <p>The javax.naming.NameClassPair.getClassName() method will return
    * the class name of obj (or NULL if obj is NULL) unless the class name
    * has been explicitly set using the javax.naming.NameClassPair.setClassName()
    * method. 
    *
    * @param name  The non-NULL name of the iterator item.
    * @param className  The class name of the object bound to name. 
    *                   If NULL, the class name of obj is returned by 
    *                   the getClassName() method. If obj is also NULL, 
    *                   the getClassName() method will return NULL.
    * @param obj   The object bound to name. Can be NULL.
    * @param attrs The attributes that were requested to be returned 
    *              with this iterator item. Cannot be NULL.
    * @param info  The NDS object information about this iterator item.
    *              Cannot be NULL.
    * @param isRelative A boolean set to TRUE if name is relative to the 
    *                   target context of the iterator, which is named 
    *                   by the first parameter of the createIterator() 
    *                   method; otherwise, set to FALSE if name is a 
    *                   URL string.
    */
   public NdsIteratorResult (
         String name,
         String className,
         Object obj, 
         Attributes attrs,
         NdsObjectInfo info,
         boolean isRelative)
   {
      super (name, className, obj, attrs, isRelative);

      this.info = info;
   }

   /**
    * Returns an NDSObjectInfo object containing information on the
    * NDS object in this iterator result.
    *
    * @return The NDS object information in this iterator result.
    */
   public NdsObjectInfo getObjectInfo ()
   {
      return (info);
   }

   /**
    * Sets the NDS object information of this iterator result to the
    * passed in value contained in the NDSObjectInfo object.
    *
    * @param info The non-NULL NDS object information to use.
    */
   public void setObjectInfo (
         NdsObjectInfo info)
   {
      this.info = info;
   }

   /**
    * Returns a string representation of the object. The contents of
    * this string are useful for debugging and are not meant to be
    * interpreted programmatically.
    *
    * @return The string representation of this iterator result.
    */
   public String toString()
   {
      return (super.toString () + ":" + getObjectInfo ());
   }

} /* NdsIteratorResult */


