
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/NdsString.java $
  $Revision: 5 $
  $Modtime: 10/18/99 10:46a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds;


import java.io.Serializable;

import com.novell.service.schema.SchemaString;


/** 
 * Provides the class from which other NDS string attribute values
 * extend.
 *
 * @see NdsCaseExactString
 * @see NdsCaseIgnoreString
 * @see NdsClassName
 * @see NdsDistinguishedName
 * @see NdsNumericString
 * @see NdsPrintableString
 * @see NdsTelephoneNumber
 */
public class NdsString implements SchemaString, Serializable
{
   protected String value;
   protected String name;

   protected NdsString ()
   {

   }

   protected NdsString (
         String name,
         String value)
   {
     this.name = name;
     this.value = value;
   }


   // ******************** SchemaValue Interface ********************

   /**
    * Compares this SchemaValue with the parameter anObject.
    * 
    * @param   anObject The SchemaValue to be compared.
    *
    * @return 0 if the argument is equal to this value; an integer
    *         less than 0 if this value is less than the argument;
    *         an integer greater than 0 if this value is greater than
    *         the argument.
    *
    * @exception Exception
    */
   public int compareTo (
         Object anObject)
      throws Exception
   {
     NdsString anotherString;

     anotherString = (NdsString) anObject;
     return (value.compareTo (anotherString.value));
   }

   /**
    * Compares this object to the specified object. The result is
    * TRUE if and only if the argument is not null and is a
    * SchemaString object that contains the same value as this object.
    * 
    * @param anObject The object with which to compare.
    *
    * @return TRUE if the objects are the same; otherwise FALSE.
    */
   public boolean equals (
         Object anObject)
   {
      if ((anObject != null) && (anObject instanceof NdsString))
      {
         NdsString anotherString = (NdsString) anObject;

         if (false == value.equals (anotherString.value))
         {
            return (false);
         }
         return (true);
      }
      return (false);
   }

  /**
   * Returns the object name.
   *
   * @return The object name as a String.
   */
   public String getName ()
   {
      return (name);
   }

   /**
    * @internal
    */
   public String getSyntaxId ()
   {
      return ("String");
   }


   // ******************** SchemaString Interface ********************

   /**
    * Returns the value of this SchemaString as a String.
    * 
    * @return The String value represented by this object.
    */
   public String stringValue ()
   {
      return (value);
   }


   // ******************** Object Class ********************
  /**
   * Creates a new object of the same class as this object. It
   * then initializes each of the new object's fields by assigning
   * Them the same value as the corresponding fields in this object.
   * No constructor is called.
   *
   * @return A clone of this object instance containing the cloned
   *         syntax.
   */
   public Object clone ()
   {
      try
      {
         NdsString string = (NdsString) super.clone ();

         string.value = this.value;
         string.name = this.name;

         return (string);
      }
      catch (CloneNotSupportedException e)
      {
         // this shouldn't happen, since we are Cloneable
         throw (new InternalError ());
      }

   } /* clone () */

   /**
    * Generates the string representation of this value. 
    * The string consists of the value's syntax id, the name
    * and its values.
    *
    * @return The String representation of the value.
    */
   public String toString ()
   {
      if (null == name)
      {
         return (getSyntaxId () + " " + value);
      }
      return (getSyntaxId () + " " + name + " = " + value);
   }

} /* NdsString */


