
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/NdsSyntaxId.java $
  $Revision: 10 $
  $Modtime: 10/18/99 10:49a $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds;


import java.util.Hashtable;


/**
 * Provides attribute syntax IDs used to interpret the data of
 * values stored in the Directory.
 *
 * <p>An attribute syntax consists of a single data type for which
 * syntax matching rules and qualifiers or directives have been
 * specified. The Syntax ID for each attribute syntax is a 32-bit
 * integer used to identify the syntax. A method is provided for
 * mapping each ID to its corresponding syntax string constant.
 */
public class NdsSyntaxId
{
   private static Hashtable syntaxes;

  /**
   * @internal
   */
   protected NdsSyntaxId ()
   {
   }


   // ******************** SyntaxIds ********************

  /**
   * Integer used to identify an Unknown attribute value.
   *
   * <p>(UNKNOWN_ID = 0)
   *
   * @see #UNKNOWN
   */
   public static final int UNKNOWN_ID = 0;

  /**
   * Integer used to identify the attributes whose values
   * are Distinguished Names.
   *
   * <p>(DISTINGUISHED_NAME_ID = 1)
   *
   * @see #DISTINGUISHED_NAME
   */
   public static final int DISTINGUISHED_NAME_ID = 1;

  /**
   * Integer used to identify attributes whose values are
   * case-sensitive Unicode strings.
   *
   * <p>(CASE_EXACT_STRING_ID = 2)
   *
   * @see #CASE_EXACT_STRING
   */
   public static final int CASE_EXACT_STRING_ID = 2;

  /**
   * Integer used to identify attributes whose value are
   * case-sensitive ordered sequences of Unicode strings.
   *
   * <p>(CASE_IGNORE_STRING_ID = 3)
   *
   * @see #CASE_IGNORE_STRING
   */
   public static final int CASE_IGNORE_STRING_ID = 3;

  /**
   * Integer used to identify attributes whose values are
   * printable strings.
   *
   * <p>(PRINTABLE_STRING_ID = 4)
   *
   * @see #PRINTABLE_STRING
   */
   public static final int PRINTABLE_STRING_ID = 4;

  /**
   * Integer used to identify attributes whose values are
   * numeric strings.
   *
   * <p>(NUMERIC_STRING_ID = 5)
   *
   * @see #NUMERIC_STRING
   */
   public static final int NUMERIC_STRING_ID = 5;

  /**
   * Integer used to identify attributes whose values are
   * ordered sequences of strings for which the case (upper
   * or lower) is not significant.
   *
   * <p>(CASE_IGNORE_LIST_ID = 6)
   *
   * @see #CASE_IGNORE_LIST
   */
   public static final int CASE_IGNORE_LIST_ID = 6;

  /**
   * Integer used to identify attributes whose values
   * represent TRUE (1) or FALSE (0).
   *
   * <p>(BOOLEAN_ID = 7)
   *
   * @see #BOOLEAN
   */
   public static final int BOOLEAN_ID = 7;

  /**
   * Integer used to identify attributes whose values are
   * signed integers.
   *
   * <p>(INTEGER_ID = 8)
   *
   * @see #INTEGER
   */
   public static final int INTEGER_ID = 8;

  /**
   * Integer used to identify attributes whose values are
   * byte strings that are not interpreted by the Directory.
   *
   * <p>(OCTET_STRING_ID = 9)
   *
   * @see #OCTET_STRING
   */
   public static final int OCTET_STRING_ID = 9;

  /**
   * Integer used to identify attributes whose values are
   * telephone numbers.
   *
   * <p>(TELEPHONE_NUMBER_ID = 10)
   *
   * @see #TELEPHONE_NUMBER
   */
   public static final int TELEPHONE_NUMBER_ID = 10;

  /**
   * Integer used to identify attributes whose values are
   * facsimile telephone numbers.
   *
   * <p>(FAX_NUMBER_ID = 11)
   *
   * @see #FAX_NUMBER
   */
   public static final int FAX_NUMBER_ID = 11;

  /**
   * Integer used to identify attributes whose values are
   * network addresses in the NetWare environment.
   *
   * <p>(NET_ADDRESS_ID = 12)
   *
   * @see #NET_ADDRESS
   */
   public static final int NET_ADDRESS_ID = 12;

  /**
   * Integer used to identify attributes whose values are
   * ordered sequences of octet strings.
   *
   * <p>(OCTET_LIST_ID = 13)
   *
   * @see #OCTET_LIST
   *
   */
   public static final int OCTET_LIST_ID = 13;

  /**
   * Integer used to identify attributes whose values
   * represent e-mail addresses.
   *
   * <p>(EMAIL_ADDRESS_ID = 14)
   *
   * @see #EMAIL_ADDRESS
   *
   */
   public static final int EMAIL_ADDRESS_ID = 14;

  /**
   * Integer used to identify attributes whose values
   * represent a file system path.
   *
   * <p>(PATH_ID = 15)
   *
   * @see #PATH
   *
   */
   public static final int PATH_ID = 15;

  /**
   * Integer used to identify attributes whose values
   * represent partition replicas.
   *
   * <p>(REPLICA_POINTER_ID = 16)
   *
   * @see #REPLICA_POINTER
   *
   */
   public static final int REPLICA_POINTER_ID = 16;

  /**
   * Integer used to identify attributes whose values
   * represent ACL entries.
   *
   * <p>(OBJECT_ACL_ID = 17)
   *
   * @see #OBJECT_ACL
   *
   */
   public static final int OBJECT_ACL_ID = 17;

  /**
   * Integer used to identify attributes whose values are
   * postal addresses.
   *
   * <p>(POSTAL_ADDRESS_ID = 18)
   *
   * @see #POSTAL_ADDRESS
   *
   */
   public static final int POSTAL_ADDRESS_ID = 18;

  /**
   * Integer used to identify attributes whose values
   * mark the time when a particular event occurred or
   * will occur.
   *
   * <p>(TIMESTAMP_ID = 19)
   *
   * @see #TIMESTAMP
   *
   */
   public static final int TIMESTAMP_ID = 19;

  /**
   * Integer used to identify attributes whose values
   * represent object class names.
   *
   * <p>(CLASS_NAME_ID = 20)
   *
   * @see #CLASS_NAME
   *
   */
   public static final int CLASS_NAME_ID = 20;

  /**
   * Integer used to identify attributes whose values
   * represent files of arbitrary binary information.
   *
   * <p>(STREAM_ID = 21)
   *
   * @see #STREAM
   *
   */
   public static final int STREAM_ID = 21;

  /**
   * Integer used to identify attributes whose values are
   * signed integers.
   *
   * <p>(COUNTER_ID = 22)
   *
   * @see #COUNTER
   *
   */
   public static final int COUNTER_ID = 22;

  /**
   * Integer used to identify attributes whose values are
   * used for Directory internal management.
   *
   * <p>(BACK_LINK_ID = 23)
   *
   * @see #BACK_LINK
   *
   */
   public static final int BACK_LINK_ID = 23;

  /**
   * Integer used to identify attributes whose values are
   * unsigned integers representing time expressed in seconds.
   *
   * <p>(TIME_ID = 24)
   *
   * @see #TIME
   *
   */
   public static final int TIME_ID = 24;

  /**
   * Integer used to identify attributes whose values represent
   * a level and an interval associated with an object.
   *
   * <p>(TYPED_NAME_ID = 25)
   *
   * @see #TYPED_NAME
   *
   */
   public static final int TYPED_NAME_ID = 25;

  /**
   * Integer used to identify attributes whose values are
   * signed integers representing accounting quantities.
   *
   * <p>(HOLD_ID = 26)
   *
   * @see #HOLD
   *
   */
   public static final int HOLD_ID = 26;

  /**
   * Integer used to identify attributes whose values
   * represent intervals of time in seconds.
   *
   * <p>(INTERVAL_ID = 27)
   *
   * @see #INTERVAL
   *
   */
   public static final int INTERVAL_ID = 27;

  /**
   * Signed integer representing the total number of syntax IDs.
   *
   * <p>(ID_COUNT = 28)
   *
   */
   public static final int ID_COUNT = 28;

   // ******************** Syntax Strings ********************


  /**
   * Represents the string constant form of the Unknown syntax ID.
   *
   * <P>(UNKNOWN = "Unknown")
   *
   * @see NdsUnknown
   */
   public static final String UNKNOWN = "Unknown";

  /**
   * Represents the string constant form of the Distinguished
   * Name syntax ID.
   *
   * <P>(DISTINGUISHED_NAME = "Distinguished Name")
   *
   * @see NdsDistinguishedName
   */
   public static final String DISTINGUISHED_NAME = "Distinguished Name";

  /**
   * Represents the string constant form of the Case Exact String
   * syntax ID.
   *
   * <P>(CASE_EXACT_STRING = "Case Exact String")
   *
   * @see NdsCaseExactString
   */
   public static final String CASE_EXACT_STRING = "Case Exact String";

  /**
   * Represents the string constant form of the Case Ignore String
   * syntax ID.
   *
   * <P>(CASE_IGNORE_STRING = "Case Ignore String")
   *
   * @see NdsCaseIgnoreString
   */
   public static final String CASE_IGNORE_STRING = "Case Ignore String";

  /**
   * Represents the string constant form of the Printable String
   * syntax ID.
   *
   * <P>(PRINTABLE_STRING = "Printable String")
   *
   * @see NdsPrintableString
   */
   public static final String PRINTABLE_STRING = "Printable String";

  /**
   * Represents the string constant form of the Numeric String
   * syntax ID.
   *
   * <P>(NUMERIC_STRING = "Numeric String")
   *
   * @see NdsNumericString
   */
   public static final String NUMERIC_STRING = "Numeric String";

  /**
   * Represents the string constant form of the Case Ignore List
   * syntax ID.
   *
   * <P>(CASE_IGNORE_LIST = "Case Ignore List")
   *
   * @see NdsCaseIgnoreList
   */
   public static final String CASE_IGNORE_LIST = "Case Ignore List";

  /**
   * Represents the string constant form of the Boolean
   * syntax ID.
   *
   * <P>(BOOLEAN = "Boolean")
   *
   * @see NdsBoolean
   */
   public static final String BOOLEAN = "Boolean";

  /**
   * Represents the string constant form of the Integer
   * syntax ID.
   *
   * <P>(INTEGER = "Integer")
   *
   * @see NdsInteger
   */
   public static final String INTEGER = "Integer";

  /**
   * Represents the string constant form of the Octet String
   * syntax ID.
   *
   * <p>(OCTET_STRING = "Octet String")
   *
   * @see NdsOctetString
   */
   public static final String OCTET_STRING = "Octet String";

  /**
   * Represents the string constant form of the Telephone Number
   * syntax ID.
   *
   * <P>(TELEPHONE_NUMBER = "Telephone Number")
   *
   * @see NdsTelephoneNumber
   */
   public static final String TELEPHONE_NUMBER = "Telephone Number";

  /**
   * Represents the string constant form of the Facsimile Telephone
   * Number syntax ID.
   *
   * <P>(FAX_NUMBER = "Facsimile Telephone Number")
   *
   * @see NdsFAXNumber
   */
   public static final String FAX_NUMBER = "Facsimile Telephone Number";

  /**
   * Represents the string constant form of the Network Address
   * syntax ID.
   *
   * <P>(NET_ADDRESS = "Network Address")
   *
   * @see NdsNetAddress
   */
   public static final String NET_ADDRESS = "Network Address";

  /**
   * Represents the string constant form of the Octet List
   * syntax ID.
   *
   * <P>(OCTET_LIST = "Octet List")
   *
   * @see NdsOctetList
   */
   public static final String OCTET_LIST = "Octet List";

  /**
   * Represents the string constant form of the EMail Address
   * syntax ID.
   *
   * <P>(EMAIL_ADDRESS = "EMail Address")
   *
   * @see NdsEMailAddress
   */
   public static final String EMAIL_ADDRESS = "EMail Address";

  /**
   * Represents the string constant form of the Path
   * syntax ID.
   *
   * <P>(PATH = "Path")
   *
   * @see NdsPath
   */
   public static final String PATH = "Path";

  /**
   * Represents the string constant form of the Replica Pointer
   * syntax ID.
   *
   * <P>(REPLICA_POINTER = "Replica Pointer")
   *
   * @see NdsReplicaPointer
   */
   public static final String REPLICA_POINTER = "Replica Pointer";

  /**
   * Represents the string constant form of the Object ACL
   * syntax ID.
   *
   * <P>(OBJECT_ACL = "Object ACL")
   *
   * @see NdsObjectACL
   */
   public static final String OBJECT_ACL = "Object ACL";

  /**
   * Represents the string constant form of the Postal Address
   * syntax ID.
   *
   * <P>(POSTAL_ADDRESS = "Postal Address")
   *
   * @see NdsPostalAddress
   */
   public static final String POSTAL_ADDRESS = "Postal Address";

  /**
   * Represents the string constant form of the Timestamp
   * syntax ID.
   *
   * <P>(TIMESTAMP = "Timestamp")
   *
   * @see NdsTimestamp
   */
   public static final String TIMESTAMP = "Timestamp";

  /**
   * Represents the string constant form of the Class Name
   * syntax ID.
   *
   * <P>(CLASS_NAME = "Class Name")
   *
   * @see NdsClassName
   */
   public static final String CLASS_NAME = "Class Name";

  /**
   * Represents the string constant form of the Stream
   * syntax ID.
   *
   * <P>(STREAM = "Stream")
   *
   * @see NdsStream
   */
   public static final String STREAM = "Stream";

  /**
   * Represents the string constant form of the Counter
   * syntax ID.
   *
   * <P>(COUNTER = "Counter")
   *
   * @see NdsCounter
   */
   public static final String COUNTER = "Counter";

  /**
   * Represents the string constant form of the Back Link
   * syntax ID.
   *
   * <P>(BACK_LINK = "Back Link")
   *
   * @see NdsBackLink
   */
   public static final String BACK_LINK = "Back Link";

  /**
   * Represents the string constant form of the Time
   * syntax ID.
   *
   * <P>(TIME = "Time")
   *
   * @see NdsTime
   */
   public static final String TIME = "Time";

  /**
   * Represents the string constant form of the Typed Name
   * syntax ID.
   *
   * <P>(TYPED_NAME = "Typed Name")
   *
   * @see NdsTypedName
   */
   public static final String TYPED_NAME = "Typed Name";

  /**
   * Represents the string constant form of the Hold
   * syntax ID.
   *
   * <P>(HOLD = "Hold")
   *
   * @see NdsHold
   */
   public static final String HOLD = "Hold";

   /**
   * Represents the string constant form of the Interval
   * syntax ID.
   *
   * <P>(INTERVAL = "Interval")
   *
   * @see NdsInterval
   */
  public static final String INTERVAL = "Interval";


   static
   {
      syntaxes = new Hashtable ();

      syntaxes.put (new Integer (UNKNOWN_ID), UNKNOWN);
      syntaxes.put (new Integer (DISTINGUISHED_NAME_ID), DISTINGUISHED_NAME);
      syntaxes.put (new Integer (CASE_EXACT_STRING_ID), CASE_EXACT_STRING);
      syntaxes.put (new Integer (CASE_IGNORE_STRING_ID), CASE_IGNORE_STRING);
      syntaxes.put (new Integer (PRINTABLE_STRING_ID), PRINTABLE_STRING);
      syntaxes.put (new Integer (NUMERIC_STRING_ID), NUMERIC_STRING);
      syntaxes.put (new Integer (CASE_IGNORE_LIST_ID), CASE_IGNORE_LIST);
      syntaxes.put (new Integer (BOOLEAN_ID), BOOLEAN);
      syntaxes.put (new Integer (INTEGER_ID), INTEGER);
      syntaxes.put (new Integer (OCTET_STRING_ID), OCTET_STRING);
      syntaxes.put (new Integer (TELEPHONE_NUMBER_ID), TELEPHONE_NUMBER);
      syntaxes.put (new Integer (FAX_NUMBER_ID), FAX_NUMBER);
      syntaxes.put (new Integer (NET_ADDRESS_ID), NET_ADDRESS);
      syntaxes.put (new Integer (OCTET_LIST_ID), OCTET_LIST);
      syntaxes.put (new Integer (EMAIL_ADDRESS_ID), EMAIL_ADDRESS);
      syntaxes.put (new Integer (PATH_ID), PATH);
      syntaxes.put (new Integer (REPLICA_POINTER_ID), REPLICA_POINTER);
      syntaxes.put (new Integer (OBJECT_ACL_ID), OBJECT_ACL);
      syntaxes.put (new Integer (POSTAL_ADDRESS_ID), POSTAL_ADDRESS);
      syntaxes.put (new Integer (TIMESTAMP_ID), TIMESTAMP);
      syntaxes.put (new Integer (CLASS_NAME_ID), CLASS_NAME);
      syntaxes.put (new Integer (STREAM_ID), STREAM);
      syntaxes.put (new Integer (COUNTER_ID), COUNTER);
      syntaxes.put (new Integer (BACK_LINK_ID), BACK_LINK);
      syntaxes.put (new Integer (TIME_ID), TIME);
      syntaxes.put (new Integer (TYPED_NAME_ID), TYPED_NAME);
      syntaxes.put (new Integer (HOLD_ID), HOLD);
      syntaxes.put (new Integer (INTERVAL_ID), INTERVAL);
   }


  /**
   * Returns the syntax string based on the specified syntax ID.
   *
   * <p>Maps each syntax ID to its corresponding syntax string
   * constant.
   *
   * @param id The specified syntax ID.
   *
   * @return The syntax string identified by the syntax ID parameter.
   */
   public static String mapIdToString (int id)
   {
      return ((String) syntaxes.get (new Integer (id)));
   }

} /* NdsSyntaxId */
