
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/SchemaClass.java $
  $Revision: 10 $
  $Modtime: 1/25/00 4:40p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds;


import com.novell.service.jncpv2.net.NetJNI;


/**
 * Defines the object components for a single NDS Class.
 * 
 * <p>Object components for a class define the types of objects
 * that can exist in the Directory tree. An object class is
 * defined by its features, which consist of the following kinds
 * of information:
 * <ul>
 * <li>Super Classes
 * <li>Class Attributes
 * <li>Class Flags
 * <li>Structure Rules
 * <li>ACL Templates
 * </ul>
 * <p>The Class Flags may have one or more of the following flags set:
 * <ul>
 * <li>DS_CONTAINER_CLASS
 * <li>DS_EFFECTIVE_CLASS
 * <li>DS_NONREMOVABLE_CLASS
 * <li>DS_AMBIGUOUS_NAMING
 * <li>DS_AMBIGUOUS_CONTAINMENT
 * </ul>
 */
public interface SchemaClass
{
   /**
    * Represents the Object Super Classes Attribute ID.
    *
    * <p>Super Classes designate the structure of the schema itself,
    * defining the association of class definitions in the class
    * hierarchy.
    *
    * <p>(ATTR_OBJECT_SUPER_CLASSES = "Object Super Classes")
    */
   public static final String ATTR_OBJECT_SUPER_CLASSES =
                        "Object Super Classes";
   /**
    * Represents the Object Containment Classes Attribute ID.
    *
    * <p>The containment classes structure rule determines where
    * in the NDS tree hierarchy the objects can be placed. Objects
    * that can contain other objects are container objects or parent
    * objects. Objects that cannot contain other objects are
    * noncontainer or leaf objects.
    *
    * <p>(ATTR_OBJECT_CONTAINMENT_CLASSES = "Object Containment Classes")
    */
   public static final String ATTR_OBJECT_CONTAINMENT_CLASSES =
                        "Object Containment Classes";
   /**
    * Represents the Object Naming Attributes Attribute ID.
    *
    * <p>The object naming attribute structure rule determines how
    * objects of the class are named. Objects are identified by 
    * their own name and the name of their parent objects. The
    * characteristics of naming attributes include: Naming attribute
    * rules, multi-valued naming attributes, shareable naming
    * attributes, and inheritance of naming attributes.
    *
    * <p>(ATTR_OBJECT_NAMING_ATTRIBUTES = "Object Naming Attributes")
    */
   public static final String ATTR_OBJECT_NAMING_ATTRIBUTES =
                        "Object Naming Attributes";
   /**
    * Represents the Object Mandatory Attributes Attribute ID.
    *
    * <p>If an attribute is mandatory, a value must be assigned
    * to the attribute before an instance of the object can be
    * created. Mandatory attributes are always inherited from
    * Super classes, and mandatory definitions take precedence
    * over optional attribute designations.
    *
    * <p>(ATTR_OBJECT_MANDATORY_ATTRIBUTES = "Object Mandatory Attributes")
    */
   public static final String ATTR_OBJECT_MANDATORY_ATTRIBUTES =
                        "Object Mandatory Attributes";
   /**
    * Represents the Object Optional Attributes Attribute ID.
    *
    * <p>If an attribute is optional, a value does not need to be
    * assigned to create an instance of the object. The only exception
    * is an optional naming attribute, but if the optional naming
    * attribute is the only attribute used for naming the object,
    * the optional attribute becomes a mandatory attribute. Optional
    * attributes are always inherited from super classes.
    *
    * <p>(ATTR_OBJECT__OPTIONAL_ATTRIBUTES = "Object Optional Attributes")
    */
   public static final String ATTR_OBJECT_OPTIONAL_ATTRIBUTES =
                        "Object Optional Attributes";
   /**
    * Represents the ASN1Name Attribute ID.
    *
    * <p>The ASN1Name is the unique identifier for the class definition
    * based on the international standard for representing data types
    * and structures. It provides a machine-independent syntax for
    * specifying application layer protocols and information on open
    * systems.
    *
    * <p>ATTR_ASN1NAME = "ASN1Name")</p>
    */
   public static final String ATTR_ASN1NAME = "ASN1Name";

   /**
    * Represents the flags attribute ID for class definitions.
    * <p> The Flags Attribute constant contains a value that is
    * a combination of the following flags that restrict the
    * attribute value:
    * <ul><li>SchemaClassDirContext.DS_CONTAINER_CLASS
    * <li>SchemaClassDirContext.DS_EFFECTIVE_CLASS
    * <li>SchemaClassDirContext.DS_NONREMOVABLE_CLASS
    * <li>SchemaClassDirContext.DS_AMBIGUOUS_NAMING
    * <li>SchemaClassDirContext.DS_AMBIGUOUS_CONTAINMENT
    * </ul>
    *
    * <p>ATTR_FLAGS = "Flags")</p>
    */
   public static final String ATTR_FLAGS = "Flags";

   // Values stored in the Flags attribute
  /**
   * Indicates whether the object can contain other objects.
   *
   * <p>This flag is set to ON for those object classes
   * that are designated as container classes. The flag is
   * set to OFF for all leaf object classes.
   *
   * <p>(DS_CONTAINER_CLASS = NetJNI.DS_CONTAINER_CLASS)
   */
   public final static int  DS_CONTAINER_CLASS =
                                 NetJNI.DS_CONTAINER_CLASS;

  /**
   * Indicates whether an object class is effective or noneffective.
   *
   * <p>The Effective flag is set to ON for those base schema
   * object classes that can be used to provide definition and to
   * create objects. The flag is set to OFF for those classes that
   * provide definition but cannot be used to create objects.
   *
   * <p>(DS_EFFECTIVE_CLASS = NetJNI.DS_EFFECTIVE_CLASS)
   */
   public final static int  DS_EFFECTIVE_CLASS =
                                 NetJNI.DS_EFFECTIVE_CLASS;

  /**
   * Indicates whether the object class can be removed from the
   * schema.
   *
   * <p>This flag is set to ON for those objects that
   * cannot be removed. The flag is set to OFF for object classes
   * that can be removed. All base schema object classes are flagged
   * nonremovable.
   *
   * <p>(DS_NONREMOVABLE_CLASS = NetJNI.DS_NONREMOVABLE_CLASS)
   */
   public final static int  DS_NONREMOVABLE_CLASS =
                                 NetJNI.DS_NONREMOVABLE_CLASS;

  /**
   * Indicates whether the object class has clearly defined
   * naming attributes.
   *
   * <p>As a general rule, noneffective classes can be created
   * with ambiguous naming, but effective classes must have
   * nonambiguous naming attributes. For most object classes in
   * the base schema, the Ambiguous Naming flag is set to OFF.
   * The only object classes where this flag is turned On are
   * Top, Alias, Person and Partition.
   *
   * <p>(DS_AMBIGUOUS_NAMING = NetJNI.DS_AMBIGUOUS_NAMING)
   */
   public final static int  DS_AMBIGUOUS_NAMING =
                                 NetJNI.DS_AMBIGUOUS_NAMING;

  /**
   * Indicates whether the object class has clearly defined
   * containment classes.
   *
   * <p>As a general rule, noneffective classes can be created
   * with ambiguous containment, but effective classes must have
   * nonambiguous containment. For most object classes in the
   * base schema, the Ambiguous Containment flag is set to OFF.
   * The only object classes where this flag is turned On are
   * Top, Alias, Person and Partition.
   *
   * <p>(DS_AMBIGUOUS_CONTAINMENT = NetJNI.DS_AMBIGUOUS_CONTAINMENT)
   */
   public final static int  DS_AMBIGUOUS_CONTAINMENT =
                                 NetJNI.DS_AMBIGUOUS_CONTAINMENT;

   /**
    *
    * <p>(DS_AUXILIARY_CLASS = NetJNI.DS_AUXILIARY_CLASS)
    */
   public final static int  DS_AUXILIARY_CLASS =
                                 NetJNI.DS_AUXILIARY_CLASS;

   /**
    *
    * <p>(DS_OPERATIONAL_CLASS = NetJNI.DS_OPERATIONAL_CLASS)
    */
   public final static int  DS_OPERATIONAL_CLASS =
                                 NetJNI.DS_OPERATIONAL_CLASS;

} /* SchemaClass */

