/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/nds/ldap/LdapAttributeValueFactory.java $
  $Revision: 1 $
  $Modtime: 3/02/98 1:36p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nds.ldap;

import com.novell.service.nds.*;

/**
 * @internal
 * The LdapAttributeValueFactory will create LdapAttributeValues from
 * a String and a syntaxId.  The factory will also convert an
 * NdsAttributeValue into a LdapAttributeValue.
 */
public final class LdapAttributeValueFactory
{
   /**
    * Create a specific LdapAttributeValue using the syntaxId.  The String
    * contains the Ldap string representation of the attribute value.
    */
   public static NdsAttributeValue createValue (
         int ndsSyntaxId,
         String value)
      throws Exception
   {
      switch (ndsSyntaxId)
      {
         case  NdsSyntaxId.UNKNOWN_ID:
         {
            return (new LdapUnknown (value));
         }

         case  NdsSyntaxId.DISTINGUISHED_NAME_ID:
         {
            return (new LdapDistinguishedName (value));
         }

         case  NdsSyntaxId.CASE_EXACT_STRING_ID:
         {
            return (new LdapCaseExactString (value));
         }

         case  NdsSyntaxId.CASE_IGNORE_STRING_ID:
         {
            return (new LdapCaseIgnoreString (value));
         }

         case  NdsSyntaxId.PRINTABLE_STRING_ID:
         {
            return (new LdapPrintableString (value));
         }

         case  NdsSyntaxId.NUMERIC_STRING_ID:
         {
            return (new LdapNumericString (value));
         }

         case  NdsSyntaxId.CASE_IGNORE_LIST_ID:
         {
            return (new LdapCaseIgnoreList (value));
         }

         case  NdsSyntaxId.BOOLEAN_ID:
         {
            return (new LdapBoolean (value));
         }

         case  NdsSyntaxId.INTEGER_ID:
         {
            return (new LdapInteger (value));
         }

         case  NdsSyntaxId.OCTET_STRING_ID:
         {
            return (new LdapOctetString (value));
         }

         case NdsSyntaxId.TELEPHONE_NUMBER_ID:
         {
            return (new LdapTelephoneNumber (value));
         }

         case NdsSyntaxId.FAX_NUMBER_ID:
         {
            return (new LdapFAXNumber (value));
         }

         case NdsSyntaxId.NET_ADDRESS_ID:
         {
            return (new LdapNetAddress (value));
         }

         case NdsSyntaxId.OCTET_LIST_ID:
         {
            return (new LdapOctetList (value));
         }

         case NdsSyntaxId.EMAIL_ADDRESS_ID:
         {
            return (new LdapEMailAddress (value));
         }

         case NdsSyntaxId.PATH_ID:
         {
            return (new LdapPath (value));
         }

         case NdsSyntaxId.REPLICA_POINTER_ID:
         {
            return (new LdapReplicaPointer (value));
         }

         case NdsSyntaxId.OBJECT_ACL_ID:
         {
            return (new LdapObjectACL (value));
         }

         case NdsSyntaxId.POSTAL_ADDRESS_ID:
         {
            return (new LdapPostalAddress (value));
         }

         case NdsSyntaxId.TIMESTAMP_ID:
         {
            return (new LdapTimestamp (value));
         }

         case NdsSyntaxId.CLASS_NAME_ID:
         {
            return (new LdapClassName (value));
         }

         case NdsSyntaxId.STREAM_ID:
         {
            return (new LdapStream (value));
         }

         case NdsSyntaxId.COUNTER_ID:
         {
            return (new LdapCounter (value));
         }

         case NdsSyntaxId.BACK_LINK_ID:
         {
            return (new LdapBackLink (value));
         }

         case NdsSyntaxId.TIME_ID:
         {
            return (new LdapTime (value));
         }

         case NdsSyntaxId.TYPED_NAME_ID:
         {
            return (new LdapTypedName (value));
         }

         case NdsSyntaxId.HOLD_ID:
         {
            return (new LdapHold (value));
         }

         case NdsSyntaxId.INTERVAL_ID:
         {
            return (new LdapInterval (value));
         }

         default:
         {
            throw (new Exception ());
         }

      } /* switch (syntaxID) */

   } /* createValue () */


   /**
    * Create a specific LdapAttributeValue from a
    * corresponding NdsAttributeValue.
    */
   public static LdapAttributeValue createValue (
         NdsAttributeValue attrValue)
      throws Exception
   {
      switch (attrValue.getNdsSyntaxId ())
      {
         case  NdsSyntaxId.UNKNOWN_ID:
         {
            return (new LdapUnknown ((NdsUnknown) attrValue));
         }

         case  NdsSyntaxId.DISTINGUISHED_NAME_ID:
         {
            return (new LdapDistinguishedName (
                           (NdsDistinguishedName) attrValue));
         }

         case  NdsSyntaxId.CASE_EXACT_STRING_ID:
         {
            return (new LdapCaseExactString (
                           (NdsCaseExactString) attrValue));
         }

         case  NdsSyntaxId.CASE_IGNORE_STRING_ID:
         {
            return (new LdapCaseIgnoreString (
                           (NdsCaseIgnoreString) attrValue));
         }

         case  NdsSyntaxId.PRINTABLE_STRING_ID:
         {
            return (new LdapPrintableString (
                           (NdsPrintableString) attrValue));
         }

         case  NdsSyntaxId.NUMERIC_STRING_ID:
         {
            return (new LdapNumericString ((NdsNumericString) attrValue));
         }

         case  NdsSyntaxId.CASE_IGNORE_LIST_ID:
         {
            return (new LdapCaseIgnoreList ((NdsCaseIgnoreList) attrValue));
         }

         case  NdsSyntaxId.BOOLEAN_ID:
         {
            return (new LdapBoolean ((NdsBoolean) attrValue));
         }

         case  NdsSyntaxId.INTEGER_ID:
         {
            return (new LdapInteger ((NdsInteger) attrValue));
         }

         case  NdsSyntaxId.OCTET_STRING_ID:
         {
            return (new LdapOctetString ((NdsOctetString) attrValue));
         }

         case NdsSyntaxId.TELEPHONE_NUMBER_ID:
         {
            return (new LdapTelephoneNumber (
                           (NdsTelephoneNumber) attrValue));
         }

         case NdsSyntaxId.FAX_NUMBER_ID:
         {
            return (new LdapFAXNumber ((NdsFAXNumber) attrValue));
         }

         case NdsSyntaxId.NET_ADDRESS_ID:
         {
            return (new LdapNetAddress ((NdsNetAddress) attrValue));
         }

         case NdsSyntaxId.OCTET_LIST_ID:
         {
            return (new LdapOctetList ((NdsOctetList) attrValue));
         }

         case NdsSyntaxId.EMAIL_ADDRESS_ID:
         {
            return (new LdapEMailAddress ((NdsEMailAddress) attrValue));
         }

         case NdsSyntaxId.PATH_ID:
         {
            return (new LdapPath ((NdsPath) attrValue));
         }

         case NdsSyntaxId.REPLICA_POINTER_ID:
         {
            return (new LdapReplicaPointer ((NdsReplicaPointer) attrValue));
         }

         case NdsSyntaxId.OBJECT_ACL_ID:
         {
            return (new LdapObjectACL ((NdsObjectACL) attrValue));
         }

         case NdsSyntaxId.POSTAL_ADDRESS_ID:
         {
            return (new LdapPostalAddress ((NdsPostalAddress) attrValue));
         }

         case NdsSyntaxId.TIMESTAMP_ID:
         {
            return (new LdapTimestamp ((NdsTimestamp) attrValue));
         }

         case NdsSyntaxId.CLASS_NAME_ID:
         {
            return (new LdapClassName ((NdsClassName) attrValue));
         }

         case NdsSyntaxId.STREAM_ID:
         {
            return (new LdapStream ((NdsStream) attrValue));
         }

         case NdsSyntaxId.COUNTER_ID:
         {
            return (new LdapCounter ((NdsCounter) attrValue));
         }

         case NdsSyntaxId.BACK_LINK_ID:
         {
            return (new LdapBackLink ((NdsBackLink) attrValue));
         }

         case NdsSyntaxId.TIME_ID:
         {
            return (new LdapTime ((NdsTime) attrValue));
         }

         case NdsSyntaxId.TYPED_NAME_ID:
         {
            return (new LdapTypedName ((NdsTypedName) attrValue));
         }

         case NdsSyntaxId.HOLD_ID:
         {
            return (new LdapHold ((NdsHold) attrValue));
         }

         case NdsSyntaxId.INTERVAL_ID:
         {
            return (new LdapInterval ((NdsInterval) attrValue));
         }

         default:
         {
            throw (new Exception ());
         }

      } /* switch (syntaxID) */

   } /* createValue () */

} /* LdapAttributeValueFactory */

