/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/nds/ldap/LdapBoolean.java $
  $Revision: 1 $
  $Modtime: 3/02/98 1:37p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nds.ldap;

import com.novell.service.nds.*;

/**
@internal
LdapBoolean is an Adapter for NdsBoolean.
*/
public final class LdapBoolean
   extends NdsBoolean
   implements LdapAttributeValue
{

   /**
   * Constructs an LdapBoolean adapter for an NdsBoolean.
   *
   * @param   value     Ldap string representation of Boolean.
   */
   protected LdapBoolean (
         String value)
   {
      this.value = (value.equals("TRUE")) ? true : false;
   }

   /**
   * Constructs an LdapBoolean adapter for an NdsBoolean.
   *
   * @param   value     an NdsBoolean object.
   */
   protected LdapBoolean (NdsBoolean value)
   {
      super (value);
   }

   /**
   * Returns an Ldap string representation of Boolean.
   *
   * @return   String containing Ldap string representation of Boolean.
   */
   public String toString ()
   {
      return (this.value == true) ? "TRUE" : "FALSE";
   }
}

