/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/nds/ldap/LdapCaseExactString.java $
  $Revision: 1 $
  $Modtime: 3/02/98 1:37p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nds.ldap;

import com.novell.service.nds.*;

/**
@internal
LdapCaseExactString is an Adapter for NdsCaseExactString.
*/
public final class LdapCaseExactString
   extends NdsCaseExactString
   implements LdapAttributeValue
{

   /**
   * Constructs an LdapCaseExactString adapter for an NdsCaseExactString.
   *
   * @param   value     Ldap string representation of CaseExactString.
   */
   protected LdapCaseExactString (
         String value)
   {
      this.value = new String(value);
   }

   /**
   * Constructs an LdapCaseExactString adapter for an NdsCaseExactString.
   *
   * @param   value     an NdsCaseExactString object.
   */
   protected LdapCaseExactString (NdsCaseExactString value)
   {
      super (value);
   }

   /**
   * Returns an Ldap string representation of CaseExactString.
   *
   * @return   String containing Ldap string representation of CaseExactString.
   */
   public String toString ()
   {
      return this.value;
   }
}

