/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/nds/ldap/LdapCaseIgnoreString.java $
  $Revision: 1 $
  $Modtime: 3/02/98 1:37p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nds.ldap;

import com.novell.service.nds.*;

/**
@internal
LdapCaseIgnoreString is an Adapter for NdsCaseIgnoreString.
*/
public final class LdapCaseIgnoreString
   extends NdsCaseIgnoreString
   implements LdapAttributeValue
{

   /**
   * Constructs an LdapCaseIgnoreString adapter for an NdsCaseIgnoreString.
   *
   * @param   value     Ldap string representation of CaseIgnoreString.
   */
   protected LdapCaseIgnoreString (
         String value)
   {
      this.value = new String(value);
   }

   /**
   * Constructs an LdapCaseIgnoreString adapter for an NdsCaseIgnoreString.
   *
   * @param   value     an NdsCaseIgnoreString object.
   */
   protected LdapCaseIgnoreString (NdsCaseIgnoreString value)
   {
      super (value);
   }

   /**
   * Returns an Ldap string representation of CaseIgnoreString.
   *
   * @return   String containing Ldap string representation of CaseIgnoreString.
   */
   public String toString ()
   {
      return this.value;
   }
}

