/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/nds/ldap/LdapInteger.java $
  $Revision: 1 $
  $Modtime: 3/02/98 1:40p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nds.ldap;

import com.novell.service.nds.*;

/**
@internal
LdapInteger is an Adapter for NdsInteger.
*/
public final class LdapInteger
   extends NdsInteger
   implements LdapAttributeValue
{

   /**
   * Constructs an LdapInteger adapter for an NdsInteger.
   *
   * @param   value     Ldap string representation of Integer.
   */
   protected LdapInteger (
         String value)
      throws Exception
   {
      this.value = Integer.parseInt(value);
   }

   /**
   * Constructs an LdapInteger adapter for an NdsInteger.
   *
   * @param   value     an NdsInteger object.
   */
   protected LdapInteger (NdsInteger value)
   {
      super (value);
   }

   /**
   * Returns an Ldap string representation of Integer.
   *
   * @return   String containing Ldap string representation of Integer.
   */
   public String toString ()
   {
      return String.valueOf(this.value);
   }
}

