/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/nds/ldap/LdapPrintableString.java $
  $Revision: 1 $
  $Modtime: 3/02/98 1:42p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nds.ldap;

import com.novell.service.nds.*;

/**
@internal
LdapPrintableString is an Adapter for NdsPrintableString.
*/
public final class LdapPrintableString
   extends NdsPrintableString
   implements LdapAttributeValue
{

   /**
   * Constructs an LdapPrintableString adapter for an NdsPrintableString.
   *
   * @param   value     Ldap string representation of PrintableString.
   */
   protected LdapPrintableString (
         String value)
   {
      this.value = new String(value);
   }

   /**
   * Constructs an LdapPrintableString adapter for an NdsPrintableString.
   *
   * @param   value     an NdsPrintableString object.
   */
   protected LdapPrintableString (NdsPrintableString value)
   {
      super (value);
   }

   /**
   * Returns an Ldap string representation of PrintableString.
   *
   * @return   String containing Ldap string representation of PrintableString.
   */
   public String toString ()
   {
      return this.value;
   }
}

