
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/NdsEnvironment.java $
  $Revision: 16 $
  $Modtime: 1/02/01 9:47a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming;


import java.io.Serializable;

import java.util.Enumeration;
import java.util.Hashtable;

import javax.naming.*;

import com.novell.service.session.*;

import com.novell.utility.naming.Environment;


/**
 * Provides the set of constant Strings that uniquely controls
 * the behavior of an NdsContext.
 *
 * @see com.novell.utility.naming.Environment
 */
public class NdsEnvironment
   extends Environment
   implements Cloneable, Serializable
{
  /**
    * Environment property containing the disallowed referrals.
    *
    * <p>(DISALLOW_REFERRALS = "java.naming.nds.disallowReferrals")</p>
   */
   public final static String DISALLOW_REFERRALS
      = "java.naming.nds.disallowReferrals";

  /**
    * Environment property containing the last connection.
    *
    * <p>(LAST_CONNECTION = "java.naming.nds.lastConnection")</p>
   */
      public final static String LAST_CONNECTION
      = "java.naming.nds.lastConnection";
      
  /**
    * Environment property containing the confidence.
    *
    * <p>(CONFIDENCE = "java.naming.nds.confidence")</p>
   */
   public final static String CONFIDENCE
      = "java.naming.nds.confidence";

  /**
    * Environment property containing the name cache depth.
    *
    * <p>(NAME_CACHE_DEPTH = "java.naming.nds.nameCacheDepth")</p>
   */
   public final static String NAME_CACHE_DEPTH
      = "java.naming.nds.nameCacheDepth";

  /**
    * Environment property containing the typeless name.
    *
    * <p>(TYPELESS_NAMES = "java.naming.nds.typelessNames")</p>
   */
   public final static String TYPELESS_NAMES
      = "java.naming.nds.typelessNames";
      
   // Confidence levels
  /**
    * Environment property containing the low confidence level.
    *
    * <p>(DCV_LOW_CONF = new Integer (0))</p>
   */
   public final static Integer DCV_LOW_CONF = new Integer (0);

  /**
    * Environment property containing the medium confidence level.
    *
    * <p>(DCV_MED_CONF = new Integer (1))</p>
   */
   public final static Integer DCV_MED_CONF = new Integer (1);

  /**
    * Environment property containing the high confidence level.
    *
    * <p>(DCV_HIGH_CONF = new Integer (2))</p>
   */
   public final static Integer DCV_HIGH_CONF = new Integer (2);

   // Context related
  /**
    * Environment property containing the object attributes.
    *
    * <p>(OBJECT_ATTRS = "OBJECT_ATTRS")</p>
   */
   public final static String OBJECT_ATTRS = "OBJECT_ATTRS";

  /**
    * Environment property containing the object attribute names.
    *
    * <p>(OBJECT_ATTR_NAMES = "OBJECT_ATTR_NAMES")</p>
   */
   public final static String OBJECT_ATTR_NAMES = "OBJECT_ATTR_NAMES";

  /**
    * Environment property containing the DSI object attributes.
    *
    * <p>(DSI_OBJECT_ATTRS = "DSI_OBJECT_ATTRS")</p>
   */
   public final static String DSI_OBJECT_ATTRS = "DSI_OBJECT_ATTRS";

  /**
    * Environment property containing the object attribute level.
    *
    * <p>(OBJECT_ATTRIBUTE_LEVEL = "java.naming.nds.objectAttributeLevel")</p>
   */
   public final static String OBJECT_ATTRIBUTE_LEVEL 
      = "java.naming.nds.objectAttributeLevel";

  /**
    * Environment property containing the default object attributes.
    *
    * <p>(DEFAULT_ATTRS = OBJECT_ATTRS)</p>
   */
   public final static String DEFAULT_ATTRS = OBJECT_ATTRS;


   // Schema related
  /**
    * Environment property containing the class definitions.
    *
    * <p>(CLASS_DEFS = "CLASS_DEFS")</p>
   */
   public final static String CLASS_DEFS = "CLASS_DEFS";

  /**
    * Environment property containing the expanded class definitions.
    *
    * <p>(EXPANDED_CLASS_DEFS = "EXPANDED_CLASS_DEFS")</p>
   */
   public final static String EXPANDED_CLASS_DEFS = "EXPANDED_CLASS_DEFS";

  /**
    * Environment property containing the information class definitions.
    *
    * <p>(INFO_CLASS_DEFS = "INFO_CLASS_DEFS")</p>
   */
   public final static String INFO_CLASS_DEFS = "INFO_CLASS_DEFS";

  /**
    * Environment property containing the full class definitions.
    *
    * <p>(FULL_CLASS_DEFS = "FULL_CLASS_DEFS")</p>
   */
   public final static String FULL_CLASS_DEFS = "FULL_CLASS_DEFS";

  /**
    * Environment property containing the class attribute level.
    *
    * <p>(CLASS_ATTRIBUTE_LEVEL = "java.naming.nds.classAttributeLevel")</p>
   */
   public final static String CLASS_ATTRIBUTE_LEVEL 
      = "java.naming.nds.classAttributeLevel";

  /**
    * Environment property containing the default class definitions.
    *
    * <p>(DEFAULT_DEFS = "CLASS_DEFS")</p>
   */
   public final static String DEFAULT_DEFS = CLASS_DEFS;


   // Transport
//   public final static String TRANSPORT_DEBUG 
//                                       = "novell.naming.transport.debug";
  /**
   * Environment property containing the current NDS transport protocol.
   *
   * <p>(NDS_TRANSPORT_PROTOCOL = "java.naming.nds.transport.protocol")</p>
   */
   public final static String NDS_TRANSPORT_PROTOCOL
      = "java.naming.nds.transport.protocol";


   /** @internal
    *
    */
   public NdsEnvironment (
         Hashtable environment)
   {
      super (environment);
   }

   /** @internal
    *
    */
   public NdsEnvironment (
         Environment environment)
      throws NamingException
   {
      super (environment);

   } /* NetEnvironment () */

   /** @internal
    * Returns the current session used by this context.
    * 
    * @return The Session object being used by this context.
    *
    * @exception NamingException When a naming error occurs.
    * @exception OperationNotSupportedException When the operation
    *            is not supported.
    */
   public Session getSession ()
      throws NamingException
   {
      throw (new OperationNotSupportedException ());
   }

   /** @internal
    * Returns the session manager for the current identity.
    *
    * @return The session manager for the current identity.
    *
    * @exception NamingException When a naming error occurs.
    */
   public SessionManager getSessionManager ()
      throws NamingException
   {
      try
      {
         SessionManager sessionManager = super.getSessionManager ();

         if(sessionManager == null)
         {
            SessionEnv env = new SessionEnv ();

            env.put (SessionEnv.INITIAL_SESSION_FACTORY,
               "com.novell.service.session.nds.NDSInitialSessionFactory:" +
               "com.novell.service.session.bindery.BinderyInitialSessionFactory");

            sessionManager = SessionManagerFactory.getSessionManager (env);

            environment.put (SESSION_MANAGER_OBJECT, sessionManager);
         }
         return (sessionManager);
      }
      catch (SessionException e)
      {
         NamingException ne = new AuthenticationException ();

         ne.setRootCause (e);
         throw (ne);
      }

   } /* getSessionManager () */


   /** @internal
    *
    *
   protected void putEnvironment (
         Hashtable environment)
      throws NamingException
   {
      // Copy additions's properties to environment's properties
      Enumeration elements = environment.keys ();

      while (elements.hasMoreElements ())
      {
         String key = (String) elements.nextElement ();

         this.environment.put (key, environment.get (key));
      }

   } * putEnvironment () */

   /** @internal
    *
    *
   public Hashtable addToEnvironment (
         Hashtable additions)
      throws NamingException
   {
      // Copy additions's properties to environment's properties
      putEnvironment (environment);

      return ((Hashtable) environment.clone ());

   } * addToEnvironment () */

   /** @internal
    *
    *
   public Hashtable removeFromEnvironment (
         Hashtable deletions)
      throws NamingException
   {
      // Remove entries
      Enumeration enumeration = deletions.keys ();

      while (enumeration.hasMoreElements ())
      {
         environment.remove (enumeration.nextElement ());
      }

      return ((Hashtable) environment.clone ());

   } * removeFromEnvironment () */

   /** @internal
    *
    */
   public String getNdsTransportProtocol ()
      throws NamingException
   {
      String transport = (String) environment.get (NDS_TRANSPORT_PROTOCOL);

      if (transport == null)
      {
         return (NCP_PROTOCOL);
      }

      transport = transport.toLowerCase ();

      if (transport.equals (NCP_PROTOCOL))
      {
         return (transport);
      }

      if (transport.equals (LDAP_PROTOCOL))
      {
         return (transport);
      }
      throw (new NamingException ());

   } /* getNdsTransportProtocol () */

   /** @internal
    *
    *
   public boolean debugTransport ()
   {
      Boolean debug = (Boolean) environment.get (TRANSPORT_DEBUG);

      if (debug == null)
      {
         return (false);
      }
      return (debug.booleanValue ());

   } * getNdsTransportProtocol () */

} /* NdsEnvironment */


