
/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/nds/naming/NdsNameClassPair.java $
  $Revision: 6 $
  $Modtime: 5/11/98 10:27a $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming;


import java.io.Serializable;

import javax.naming.NameClassPair;

import com.novell.service.nds.NdsObjectInfo;


/** @internal
 *
 */
public final class NdsNameClassPair
   extends NameClassPair
   implements Serializable
{
   private String ndsClassName;
   private NdsObjectInfo ndsObjectInfo;

   /**
    *
    */
   public NdsNameClassPair (
         String entryRDN,
         NdsObjectInfo ndsObjectInfo)
   {
      super (entryRDN, null);

      this.ndsObjectInfo = ndsObjectInfo;
   }


   /**
    *
    */
   public String getClassName ()
   {
      return (ndsClassName);
   }

   /**
    * @ deprecated
    */
   public String getBaseClass ()
   {
      return (ndsObjectInfo.getBaseClass ());
   }

   /**
    *
    */
   public NdsObjectInfo getObjectInfo ()
   {
      return (ndsObjectInfo);
   }

   /**
    *
    */
   public void setClassName (String className)
   {
      this.ndsClassName = className;
   }

} /* NdsNameClassPair */


