
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/local/NdsContextFactory.java $
  $Revision: 8 $
  $Modtime: 1/28/00 12:45p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.local;


import java.util.Hashtable;
import java.util.Properties;

import java.lang.reflect.*;

import javax.naming.*;
import javax.naming.directory.*;
import javax.naming.spi.ObjectFactory;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.naming.NdsName;
import com.novell.service.nds.naming.NetSyntax;
import com.novell.service.nds.naming.NdsEnvironment;
import com.novell.service.nds.naming.NdsDataAccessor;
import com.novell.service.nds.naming.Schema;
import com.novell.service.nds.naming.TransportContextFactoryBuilder;

import com.novell.utility.naming.Environment;
import com.novell.utility.naming.URLParser;
import com.novell.utility.naming.spi.ContextFactory;
import com.novell.utility.naming.spi.ContextFactoryBuilder;


/** @internal
 *
 */
public final class NdsContextFactory implements ContextFactory
{
   private static ContextFactoryBuilder builder;

   private static String defaultClass;
   private static Properties wrapperClasses;


   static
   {
      builder = new TransportContextFactoryBuilder ();

      defaultClass = "com.novell.service.nds.naming.local.NdsDirContext";
      wrapperClasses = new Properties ();

      wrapperClasses.put (
               Schema.AFP_SERVER,
               "com.novell.service.nds.naming.local.AFPServerDirContext");
      wrapperClasses.put (
               Schema.ALIAS ,
               "com.novell.service.nds.naming.local.AliasDirContext");
      wrapperClasses.put (
               Schema.BINDERY_OBJECT,
               "com.novell.service.nds.naming.local.BinderyObjectDirContext");
      wrapperClasses.put (
               Schema.BINDERY_QUEUE,
               "com.novell.service.nds.naming.local.BinderyQueueDirContext");
      wrapperClasses.put (
               Schema.COMPUTER,
               "com.novell.service.nds.naming.local.ComputerDirContext");
      wrapperClasses.put (
               Schema.COUNTRY,
               "com.novell.service.nds.naming.local.CountryDirContext");
      wrapperClasses.put (
               Schema.DIRECTORY_MAP,
               "com.novell.service.nds.naming.local.DirectoryMapDirContext");
      wrapperClasses.put (
               Schema.GROUP,
               "com.novell.service.nds.naming.local.GroupDirContext");
      wrapperClasses.put (
               Schema.LIST,
               "com.novell.service.nds.naming.local.ListDirContext");
      wrapperClasses.put (
               Schema.LOCALITY,
               "com.novell.service.nds.naming.local.LocalityDirContext");
      wrapperClasses.put (
               Schema.MESSAGE_ROUTING_GROUP,
               "com.novell.service.nds.naming.local.MessageRoutingGroupDirContext");
      wrapperClasses.put (
               Schema.MESSAGING_SERVER,
               "com.novell.service.nds.naming.local.MessagingServerDirContext");
      wrapperClasses.put (
               Schema.NCP_SERVER,
               "com.novell.service.nds.naming.local.NCPServerDirContext");
      wrapperClasses.put (
               Schema.ORGANIZATION,
               "com.novell.service.nds.naming.local.OrganizationDirContext");
      wrapperClasses.put (
               Schema.ORGANIZATIONAL_ROLE,
               "com.novell.service.nds.naming.local.OrganizationalRoleDirContext");
      wrapperClasses.put (
               Schema.ORGANIZATIONAL_UNIT,
               "com.novell.service.nds.naming.local.OrganizationalUnitDirContext");
      wrapperClasses.put (
               Schema.PRINT_SERVER,
               "com.novell.service.nds.naming.local.PrintServerDirContext");
      wrapperClasses.put (
               Schema.PRINTER,
               "com.novell.service.nds.naming.local.PrinterDirContext");
      wrapperClasses.put (
               Schema.PROFILE,
               "com.novell.service.nds.naming.local.ProfileDirContext");
      wrapperClasses.put (
               Schema.QUEUE,
               "com.novell.service.nds.naming.local.QueueDirContext");
      wrapperClasses.put (
               Schema.TOP,
               "com.novell.service.nds.naming.local.TopDirContext");
      wrapperClasses.put (
               Schema.UNKNOWN,
               "com.novell.service.nds.naming.local.UnknownDirContext");
      wrapperClasses.put (
               Schema.USER,
               "com.novell.service.nds.naming.local.UserDirContext");
      wrapperClasses.put (
               Schema.VOLUME,
               "com.novell.service.nds.naming.local.VolumeDirContext");

   } /* static */


   /**
    *
    */
   public NdsContextFactory ()
   {

   }

   /**
    *
    */
   public NdsContextFactory (NdsEnvironment environment)
   {

   }


   /**
    * Returns Nds 'wrapped' contexts
    */
   public Object getObjectInstance (
         Object object,
         Name name,
         Context nameCtx,
         Hashtable environment)
      throws Exception
   {
      try
      {
         NdsEnvironment ndsEnvironment = new NdsEnvironment (environment);

         if (object instanceof Reference)
         {
            StringRefAddr address;
            URLParser urlParser;

            address = (StringRefAddr) ((Reference) object).get (0);
            urlParser = new URLParser ((String) address.getContent ());

            ndsEnvironment.addToEnvironment (
                              Context.PROVIDER_URL,
                              urlParser.getURL ());

            return (getContextInstance (
                        getCanonicalName (urlParser.getPath ()),
                        ndsEnvironment));
         }

         if (object instanceof String)
         {
            return (getContextInstance ((String) object, ndsEnvironment));
         }

         if (object instanceof CompoundName)
         {
            return (getContextInstance (object.toString (), ndsEnvironment));
         }
//         throw (new Exception ());
         return null;
      }
      catch (NamingException e)
      {
         // Ignore, just return null as per spi doc
         return null;
      }

   } /* createObject () */

   /**
    *
    */
   public Context getContextInstance (
         String contextName,
         Environment environment)
      throws NamingException
   {
      Context context;
      ContextFactory factory;
      NdsEnvironment ndsEnvironment = getEnvironmentInstance (environment);

      // Get transport specific factory
      factory = builder.createContextFactory (contextName, ndsEnvironment);

      // Create transport specific context
      context = factory.getContextInstance (contextName, ndsEnvironment);

      // Wrap with local NdsContext
      return (getContextInstance (context));

   } /* getContextInstance () */

   /**
    *
    */
   public Context getContextInstance (
         String contextName,
         Object classInfo,
         Environment environment)
      throws NamingException
   {
      throw (new OperationNotSupportedException ());
   }

   /**
    *
    */
   public Context getContextInstance (
         Object context)
      throws NamingException
   {
      if (!(context instanceof NdsDataAccessor))
      {
         throw (new NamingException ());
      }

      NdsDataAccessor ndsAccessor = (NdsDataAccessor) context;

      try
      {
         Class cls;
         Class[] argTypes = new Class [2];
         Constructor ctor;
         Object[] args = new Object [2];

         cls = Class.forName (getClassName (ndsAccessor));

         argTypes [0] = Class.forName (
            "com.novell.service.nds.naming.NdsDirContextWrappable");
         argTypes [1] = Class.forName (
            "com.novell.service.nds.naming.NdsEnvironment");
         ctor = cls.getDeclaredConstructor (argTypes);

         args [0] = ndsAccessor;
         args [1] = ndsAccessor.getEnvironmentInstance ();

         return ((Context) ctor.newInstance (args));
      }
      catch (ClassNotFoundException e)
      {
         NamingException ne = new NamingException ();

         ne.setRootCause (e);
         throw (ne);
      }
      catch (SecurityException e)
      {
         NamingException ne = new NamingException ();
         ne.setRootCause (e);
         throw (ne);
      }
      catch (NoSuchMethodException e)
      {
         NamingException ne = new NamingException ();
         ne.setRootCause (e);
         throw (ne);
      }
      catch (InstantiationException e)
      {
         NamingException ne = new NamingException ();

         ne.setRootCause (e);
         throw (ne);
      }
      catch (IllegalAccessException e)
      {
         NamingException ne = new NamingException ();

         ne.setRootCause (e);
         throw (ne);
      }
      catch (IllegalArgumentException e)
      {
         NamingException ne = new NamingException ();
         ne.setRootCause (e);
         throw (ne);
      }
      catch (InvocationTargetException e)
      {
         NamingException ne = new NamingException ();
         ne.setRootCause (e);
         throw (ne);
      }

   } /* getContextInstance () */

   /**
    *
    */
   public String getClassName (
         Object object)
      throws NamingException
   {
      try
      {
         String baseClass;

         if (object instanceof NdsDataAccessor)
         {
            baseClass = ((NdsDataAccessor) object).getBaseClass ();
         }
         else if (object instanceof String)
         {
            baseClass = (String) object;
         }
         else
         {
            throw (new NamingException ());
         }

         return (wrapperClasses.getProperty (baseClass, defaultClass));
      }
      catch (NSIException e)
      {
         throw (new NamingException ());
      }

   } /* getClassName () */

   /**
    *
    */
   private NdsEnvironment getEnvironmentInstance (
         Environment environment)
      throws NamingException
   {
      if (environment instanceof NdsEnvironment)
      {
         return ((NdsEnvironment) environment);
      }
      return (new NdsEnvironment (environment));

   } /* getEnvironmentInstance () */

   /**
    *
    */
   private String getCanonicalName (
         String path)
      throws NamingException
   {
      NdsName name;

      name = new NdsName ((path == null) ? "" : path, new NetSyntax ());

      return (name.getCanonicalString ());
   }

} /* NdsContextFactory */


