
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/local/ReplicaDirContext.java $
  $Revision: 6 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.local;


import java.io.Serializable;

import javax.naming.NamingException;

import com.novell.service.nds.NdsReplica;
import com.novell.service.nds.naming.NdsEnvironment;
import com.novell.service.nds.naming.PartitionDirContextWrappable;
import com.novell.service.nds.naming.NdsPartitionOperationException;

import com.novell.service.jncp.NSIException;


/** @internal
 *
 */
public class ReplicaDirContext
   extends PartitionDirContextWrapper
   implements NdsReplica, Serializable
{
   /**
    *
    */
   protected ReplicaDirContext (
         PartitionDirContextWrappable impl,
         NdsEnvironment environment)
      throws NamingException
   {
      super (impl, environment);
   }


   // ******************** NdsReplica Interface ********************

   /**
    *
    */
   public void setReplicaType (
         int type)
      throws NdsPartitionOperationException
   {
      ((NdsReplica) impl).setReplicaType (type);
   }

   /**
    *
    */
   public void syncReplica (
         String destServer,
         int flags,
         int delay)
      throws NdsPartitionOperationException
   {
      ((NdsReplica) impl).syncReplica (destServer, flags, delay);
   }

   /**
    *
    */
   public void syncReplica (
         int delay)
      throws NdsPartitionOperationException
   {
      ((NdsReplica) impl).syncReplica (delay);
   }

   /**
    * This replica receives updates from the master replica.
    *
    * @exception NSIException
    */
   public void receiveUpdates ()
      throws NSIException
   {
      ((NdsReplica) impl).receiveUpdates ();
   }

   /**
    * This replica sends updates to all other replicas.
    *
    * @exception NSIException
    */
   public void sendUpdates ()
      throws NSIException
   {
      ((NdsReplica) impl).sendUpdates ();
   }

} /* ReplicaDirContext */


