
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/net/NetAttribute.java $
  $Revision: 17 $
  $Modtime: 11/01/01 11:13a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import java.lang.StringBuffer;

import java.util.Enumeration;

import javax.naming.*;
import javax.naming.directory.*;

import com.novell.service.nds.*;
import com.novell.service.nds.net.NetAttributeValue;
import com.novell.service.nds.naming.*;

import com.novell.service.jncp.*;

import com.novell.service.jncpv2.net.*;
import com.novell.service.jncpv2.net.NetAttrRecord;

import com.novell.service.toolkit.jcl.NWInteger;

import com.novell.service.nds.net.NetAttributeValueFactory;
import com.novell.service.nds.net.NetStream;

import com.novell.utility.naming.spi.ContextFactory;


/** @internal
 *
 */
public final class NetAttribute extends BasicAttribute
{
   private static NameParser nameParser = new NdsNameParser ();
   private static ContextFactory factory = new SchemaContextFactory ();
   private static NdsNamingExceptionFactory exceptionFactory =
       new NdsNamingExceptionFactory ();


   private int syntaxId;

   private String objectName;
   private NetService service;
   private NetEnvironment environment;


   /**
    *
    */
   protected NetAttribute (
         String objectName,
         NetEnvironment environment,
         NetBuffer objectInfo)
      throws NamingException
   {
      super (null);

      this.objectName = objectName;
      try
      {
         String level = environment.getObjectAttributeLevel ();

         StringBuffer attributeName = new StringBuffer ();
         NWInteger valueCount = new NWInteger ();
         NWInteger syntaxId = new NWInteger ();

         objectInfo.getAttrName (attributeName, valueCount, syntaxId);

         this.attrID = new String (attributeName);
         this.syntaxId = syntaxId.getValue ();
         this.environment = environment;
         this.service = environment.getService ();

         NetAttributeValueFactory factory = new NetAttributeValueFactory ();

         if (level.equals (NdsEnvironment.OBJECT_ATTRS))
         {
            for (int i = valueCount.getValue (); i > 0; i--)
            {
               byte[] value = objectInfo.getAttributeValue (this.syntaxId);

               this.add (factory.createValue (
                                          this.syntaxId, 
                                          value,
                                          environment.getSession (),
                                          environment.getService (),
                                          objectName,
                                          attrID));
            }
         }
      }
      catch (NSIException e)
      {
			NamingException ne = exceptionFactory.getNamingException (e);

         e.printStackTrace ();
         throw (ne);
      }

   } /* NdsAttribute () */
   
   /**
    *
    */
   protected NetAttribute (
         String objectName,
         NetEnvironment environment,
         NetAttrRecord attrRecord)
      throws NamingException
   {
      super (attrRecord.getName ());

      this.objectName = objectName;
      this.syntaxId = attrRecord.getSyntaxId ();
      this.environment = environment;
      this.service = environment.getService ();

      NetAttributeValue[] values = attrRecord.getValues ();

      if (values != null)
      {
         for (int i = 0; i < values.length; i++)
         {
            if (syntaxId == NdsSyntaxId.STREAM_ID)
            {
               ((NetStream) values[i]).initialize (
                                                      environment.getSession (),
                                                      environment.getService (),
                                                      objectName,
                                                      attrRecord.getName (),
                                                      environment.getBatchSize ());
            }
	    // assume values are unique
	    super.values.addElement (values[i]);
         }
      }

   } /* NdsAttribute () */
   
   /**
    *
    */
   protected NetAttribute (
         String attrName,
         NdsAttributeValue attrVal)
      throws NamingException
   {
      super (attrName, attrVal);
      this.syntaxId = attrVal.getNdsSyntaxId ();
   }

   /**
    *
    */
   protected void add (
         NetAttrRecord attrRecord)
   {
      Object[] value = attrRecord.getValues ();

      for (int i = 0; i < value.length; i++)
      {
         // assume values are unique
         super.values.addElement (value[i]);
      }
   }

   /**
    *
    */
   public DirContext getAttributeDefinition ()
      throws NamingException
   {
      Name target;

//Note: needs non-global schema enhancement
      target = nameParser.parse (attrID);
//      target = nameParser.parse ("AT=" + attrID);
      target.add (0, "SC=Attributes");
      target.add (0, "SC=Schema");

      return ((DirContext) factory.getContextInstance (
                                       target.toString (),
                                       environment));

   } /* getAttributeDefinition () */

   /**
    *
    */
   public DirContext getAttributeSyntaxDefinition ()
      throws NamingException
   {
      Name target;

//Note: needs non-global schema enhancement
      target = nameParser.parse (
//                              "SY=" + NdsSyntaxId.mapIdToString (syntaxId));
                                    NdsSyntaxId.mapIdToString (syntaxId));
      target.add (0, "SC=Syntaxes");
      target.add (0, "SC=Schema");

      return ((DirContext) factory.getContextInstance (
                                       target.toString (),
                                       Schema.SCHEMA_SYNTAX,
                                       environment));

   } /* getAttributeSyntaxDefinition () */


   /**
    *
    */
   public int getSyntaxId ()
   {
      return this.syntaxId;
   }

   /**
    * Generates the string representation of this attribute.
    * The string consists of the attribute's id and its values.
    * This string is meant for debuggin and not meant to be 
    * interpreted programmatically.
    * @return The non-null string representation of this attribute.
    */
   public String toString ()
   {
      StringBuffer answer = new StringBuffer (attrID + ": ");

      if (values.size() == 0)
      {
         answer.append ("null");
      }
      else
      {
         Enumeration e = values.elements ();

         answer.append (e.nextElement ());

         while (e.hasMoreElements())
         {
            answer.append (", ");
            answer.append (e.nextElement ());
         }
      }
      return (answer.toString ());

    }

   /**
    *
    */
   protected boolean equalsApproximate (
         Object object)
   {
      if ((object != null) && (object instanceof NetAttrRecord))
      {
         NetAttrRecord target = (NetAttrRecord) object;

         if (attrID.equals (target.getName ()))
         {
            return (true);
         }
         return (false);
      }
      if ((object != null) && (object instanceof NetAttribute))
      {
         NetAttribute target = (NetAttribute) object;

         if (attrID.equals (target.getID ()))
         {
            return (true);
         }
         return (false);
      }
      return (false);

   } /*  */

} /* NetAttribute */


