
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/net/NetFilteredBindingEnumerator.java $Revision:
  $Modtime:

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import java.io.*;

import java.util.*;

import javax.naming.*;
import javax.naming.directory.*;

import com.sun.jndi.toolkit.*;

import com.novell.service.jncp.*;
import com.novell.service.jncpv2.clx.ClxJNI;

import com.novell.service.nds.*;
import com.novell.service.nds.naming.*;
import com.novell.service.nds.naming.NdsDirContextWrappable;
import com.novell.service.nds.net.*;
import com.novell.service.nds.ldap.LdapAttributeValueFactory;

import com.novell.service.session.SessionException;
import com.novell.service.jncpv2.net.*;

import com.novell.service.toolkit.jcl.NWInteger;

import com.novell.utility.naming.Environment;
import com.novell.utility.naming.directory.NAttributes;
import com.novell.utility.naming.spi.ContextFactory;
import com.novell.utility.naming.spi.ContextFactoryBuilder;


/** @internal
 *
 */
class NetFilteredBindingEnumerator
      implements NamingEnumeration, NdsNamingEnumeratorWrappable
{
   private static ContextFactory factory = new NetContextFactory ();
   private static NdsNamingExceptionFactory exceptionFactory =
       new NdsNamingExceptionFactory ();

   private boolean containers = false;
   private NetIterationHandle iterationHandle;
   private Enumeration entries;
   private String objectName;
   private String className;
   private String subordinateName;
   private NetEnvironment environment;
   private NetService service;
   private NetListBuffer subordinates;


   /**
    *
    */
   NetFilteredBindingEnumerator (
         String objectName,
         boolean containers,
         NetEnvironment environment)
      throws NamingException
   {
      this.objectName = objectName;
      this.environment = environment;
      this.service = environment.getService ();
      this.containers = true;

      try
      {
         iterationHandle = new NetIterationHandle (
                                    service,
                                    NetJNI.DSV_LIST);
         subordinates = new NetListBuffer (
                                 service,
                                 environment.getBatchSize ());
         getSubordinates ();
      }
      catch (NSIException e)
      {
         NamingException ne = exceptionFactory.getNamingException (e);
         throw (ne);
      }

   } /* NetFilteredBindingEnumerator () */


   /**
    *
    */
   NetFilteredBindingEnumerator (
         String objectName,
         String className,
         String subordinateName,
         NetEnvironment environment)
      throws NamingException
   {
      this.objectName = objectName;
      this.className = className;
      this.subordinateName = subordinateName;
      this.environment = environment;
      this.service = environment.getService ();

      try
      {
         iterationHandle = new NetIterationHandle (
                                    service,
                                    NetJNI.DSV_LIST);
         subordinates = new NetListBuffer (
                                 service,
                                 environment.getBatchSize ());
         getSubordinates ();
      }
      catch (NSIException e)
      {
         NamingException ne = exceptionFactory.getNamingException (e);
         throw (ne);
      }

   } /* NetFilteredBindingEnumerator () */

   /**
    *
    */
   private void getSubordinates ()
      throws NSIException
   {
      try
      {                     
         if (containers)
         {
            service.listContainers (
                        objectName,
                        iterationHandle,
                        subordinates);
         }
         else
         {
            service.listByClassAndName (
                        objectName,
                        className,
                        subordinateName,
                        iterationHandle,
                        subordinates);
         }

         entries = subordinates.getEntries ();
      }
      catch (SessionException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }

   } /* getSubordinates () */

   public boolean hasMoreElements ()
   {
      if (!entries.hasMoreElements () && !iterationHandle.moreIterations ())
      {
         return (false);
      }
      return (true);
   }

   /**
    *
    */
   public boolean hasMore ()
      throws NamingException
   {
      return (hasMoreElements ());
   }

   /**
    *
    */
   public Object next ()
      throws NamingException
   {
      if (!this.hasMoreElements ())
      {
         throw (new NoSuchElementException ());
      }

      try
      {
         if (!entries.hasMoreElements ())
         {
            getSubordinates ();
         }

         NetEntryInfo entryInfo = (NetEntryInfo) entries.nextElement ();

         return (new Binding (
                        entryInfo.getEntryRDN (),
                        factory.getContextInstance (
                                    entryInfo.getEntryDN (),
                                    entryInfo,
                                    environment)));
      }
      catch (NSIException e)
      {
         NamingException ne = exceptionFactory.getNamingException (e);
         throw (ne);
      }

   } /* next () */

   /**
    *
    */
   public Object nextElement ()
   {
      try
      {
         return (next ());
      }
      catch (NamingException e)
      {
         throw (new NoSuchElementException ());
      }

   } /* nextElement () */

   /**
    *
    */
   public void close ()
      throws NamingException
   {
		try
		{
			iterationHandle.closeIteration ();
		}
      catch (NSIException e)
      {
         NamingException ne = exceptionFactory.getNamingException (e);
         throw (ne);
      }
   }

} /* NetFilteredBindingEnumerator */


