
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/net/NetNameClassPairEnumerator.java $
  $Revision: 7 $
  $Modtime: 1/28/00 12:46p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import java.util.Enumeration;
import java.util.NoSuchElementException;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.naming.NdsNameClassPair;
import com.novell.service.nds.naming.NdsNamingEnumeratorWrappable;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;

import com.novell.service.jncpv2.net.NetService;
import com.novell.service.jncpv2.net.BasicNetService;
import com.novell.service.jncpv2.net.NetEntryInfo;
import com.novell.service.jncpv2.net.NetEntryInfoEnumerator;


/** @internal
 *
 */
class NetNameClassPairEnumerator
   implements NamingEnumeration, NdsNamingEnumeratorWrappable
{
   private static NdsNamingExceptionFactory exceptionFactory =
       new NdsNamingExceptionFactory ();

   private NetService service;
   private String objectName;
   private NetEnvironment environment;

   private Enumeration entries;


   /**
    *
    */
   NetNameClassPairEnumerator (
         String objectName,
         NetEnvironment environment)
      throws NamingException
   {
      try
      {
         this.objectName = objectName;
         this.service = environment.getService ();
         this.environment = environment;

         entries = new NetEntryInfoEnumerator (
                                                service,
                                                objectName,
                                                environment.getBatchSize ());
      }
      catch (NSIException e)
      {
         NamingException ne = exceptionFactory.getNamingException (e);
         throw (ne);
      }

   } /* NetNameClassPairEnumerator () */

   public boolean hasMoreElements ()
   {
      return (entries.hasMoreElements ());
   }

   /**
    *
    */
   public boolean hasMore ()
      throws NamingException
   {
      return (entries.hasMoreElements ());
   }

   /**
    *
    */
   public Object nextElement ()
   {
      try
      {
         return (next ());
      }
      catch (NamingException e)
      {
         throw (new NoSuchElementException ());
      }

   } /* nextElement () */

   /**
    *
    */
   public Object next ()
      throws NamingException
   {
      try
      {
         NetEntryInfo entryInfo = (NetEntryInfo) entries.nextElement ();

         return (new NdsNameClassPair (
                        entryInfo.getEntryRDN (),
                        entryInfo));
      }
      catch (NSIException e)
      {
         NamingException ne = exceptionFactory.getNamingException (e);
         throw (ne);
      }

   } /* next () */

   /**
    *
    */
   public void close ()
      throws NamingException
   {
      // No code is necessary here. The underlying C code processes
      // the iteration handle. All results are returned at once.
   }

} /* NetNameClassPairEnumerator */


