
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/net/NetPartitionBindingEnumerator.java $
  $Revision: 7 $
  $Modtime: 1/28/00 12:42p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import java.util.*;
import javax.naming.*;

import com.novell.service.jncp.*;

import com.novell.service.nds.naming.NdsNamingExceptionFactory;

/** @internal
 *
 *  NdsPartitionBindingEnumerator class.
 */
public class NetPartitionBindingEnumerator implements NamingEnumeration 
{
   private NetPartitionEnumerator partEnum;
   private NetEnvironment netEnv;
   private static NdsNamingExceptionFactory exceptionFactory =
       new NdsNamingExceptionFactory ();

    /**
     *  Constructs a NdsPartitionBindingEnumerator object.
     *
     *  @param netEnv           Net Environment.
     *  @param startObjectDN    FDN of the NDS object from which the search starts.
     *
     *  @exception NamingException
     */
   public NetPartitionBindingEnumerator(
                    NetEnvironment netEnv,
                    String startObjectDN)
      throws NamingException
   {
      try {
         this.partEnum = new NetPartitionEnumerator(
                netEnv.getService (),
                startObjectDN);
         this.netEnv = netEnv;
      }
      catch (NSIException e) {
			NamingException ne = exceptionFactory.getNamingException (e);
         throw ne;
      }
   }


   /**
    * Tests if this enumeration contains more elements.
    */
   public boolean hasMoreElements()
   {
      return this.partEnum.hasMoreElements();
   }

   /**
    * Returns the next element of this enumeration.
    */
   public Object nextElement()
      throws NoSuchElementException
   {
      String partName = (String)this.partEnum.nextElement();
      NetPartitionDirContext dsCtx = null;

      try {
         dsCtx = new NetPartitionDirContext(partName, netEnv);
      }
      catch (NamingException e) {
         throw new NoSuchElementException(e.getMessage());
      }

      return new Binding(partName, dsCtx);
   }

   /**
    * Tests if this enumeration contains more elements.
    */
   public boolean hasMore ()
   {
      return (this.hasMoreElements ());
   }

   /**
    * Returns the next element of this enumeration.
    */
   public Object next ()
      throws NamingException
   {
      return (this.nextElement ());
   }

   /**
    *
    */
   public void close ()
      throws NamingException
   {
		partEnum.closeIteration ();
   }

} /*  */


