
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/net/NetPartitionDirContextFactory.java $
  $Revision: 5 $
  $Modtime: 1/28/00 12:42p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import java.util.Hashtable;
import java.util.Properties;

import javax.naming.*;
import javax.naming.directory.*;
import javax.naming.spi.ObjectFactory;

import  com.sun.jndi.toolkit.*;

import com.novell.service.nds.naming.*;
import com.novell.service.jncp.*;
import com.novell.service.jncpv2.net.*;


/** @internal
 * The JNDI framework allows for object implementations to be loaded in
 * dynamically via "object factories."  For example, when looking up a
 * printer bound in the name space, if the print service binds printer names
 * to References, the printer Reference could be used to create a printer
 * object, so that the caller of lookup can directly operate on the printer
 * object after the lookup.  An ObjectFactory is responsible for creating
 * objects of a specific type.  In the above example, you may have a
 * PrinterObjectFactory for creating Printer objects.
 *
 * Each object factory must export the ObjectFactory interface.
 */

public final class NetPartitionDirContextFactory implements ObjectFactory
{
   private static NameParser nameParser = new NdsNameParser ();
//   private static Properties classes = new Properties ();

/*

   static
   {
      classes.put (
               "Directory Map",
               "com.novell.service.nds.DirectoryMapDirContext");
   }
*/


   /**
    *
    */
   public NetPartitionDirContextFactory ()
   {

   }


   /**
    * Creates an object using the location or reference information
    * specified.  Special requirements of this object are supplied
    * using 'environment'.
    *
    * An example of such an environment property is user identity
    * information.
    *
    * @param object  The object containing location or reference
    *                information that can be used in creating an object.
    * @param environment   Environment properties that are used in
    *                      creating the object.
    * @return The object created.
    */
   public Object getObjectInstance (
         Object object,
         Name name,  //NOTE: name needs to be implemented
         Context nameCtx,  //NOTE: name needs to be implemented
         Hashtable environment)
      throws Exception
   {
      NetEnvironment netEnvironment = new NetEnvironment (environment);

//       * object passed should be DN of root

      if (object instanceof String)
      {
         return (createNdsPartitionContext ((String) object, netEnvironment));
      }

      if (object instanceof CompoundName)
      {
         return (createNdsPartitionContext (object.toString (), netEnvironment));
      }
      throw (new Exception ());

   } /* getObjectInstance () */



   /**
    *
    */
   public NdsPartitionDirContext createNdsPartitionContext (
         String name,
         NetEnvironment netEnvironment)
      throws NamingException
   {
//      String baseClass;
      DirContext dsContext;
      NdsPartitionDirContextFactory factory = new NdsPartitionDirContextFactory ();


      dsContext = createAtomicDirContext (name, netEnvironment);
//      baseClass = ((NetPartitionDirContext) dsContext).getBaseClass ();

      return (factory.createNdsPartitionContext (dsContext, name));

   } /* createNdsPartitionContext () */


   /**
    *
    */
/*
   NdsPartitionDirContext createPartitionContext (
         DirContext contextImpl,
         String baseClass)
      throws NamingException
   {
      NdsDirContextFactory factory = new NdsDirContextFactory ();

      return (factory.createNdsContext (contextImpl, baseClass));

   } // createPartitionContext ()
*/


   /**
    * Create an object using for dn that is appropriate for
    * an NDS object with the specified objectClass
    */
   NetPartitionDirContext createAtomicDirContext (
         String objectName,
         NetEnvironment netEnvironment)
      throws NamingException
   {
      return (new NetPartitionDirContext (
                     objectName,
                     netEnvironment));

   } /* createAtomicDirContext () */

} /* NDSObjectFactory */


