
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/net/NetSchemaDefinitionDirContext.java $
  $Revision: 6 $
  $Modtime: 8/11/99 11:50a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import java.util.*;

import javax.naming.*;
import javax.naming.directory.*;

import com.sun.jndi.toolkit.ctx.*;

import com.novell.utility.naming.EmptyNamingEnumerator;


/** @internal
 * This class contains code common to NetAttributeDefinitionDirContext,
 * NetClassDefinitionDirContext and NetSyntaxDefinitionDirContext
 * and is subclassed by each.
 */
public abstract class NetSchemaDefinitionDirContext
      extends NetSchemaDirContext
{
   /**
    * Constructor.
    *
    * @param objectName    Distinguished name of this object
    * @param baseClass     NDS class name
    * @param netEnvironment properties to be set in this objects environment
    */
   protected NetSchemaDefinitionDirContext (
         String objectName,
         String baseClass,
         NetEnvironment netEnvironment)
      throws NamingException
   {
      super (objectName, baseClass, netEnvironment);
   }

   // Added for optimization. This is always terminal.  If anything is in name, error
   protected HeadTail p_resolveIntermediate(Name name, Continuation cont) 
      throws NamingException 
   {
      int ret = TERMINAL_COMPONENT;

      if (name.size() != 0)
      {
         NamingException e = new InvalidNameException();
         cont.setError(this, name);
         throw cont.fillInException(e);
      }
         
      cont.setSuccess();	// initialize
      HeadTail p = new HeadTail(name, name, TERMINAL_COMPONENT);
      return p;
   }

   /* ***********************************************************************
    * protected Toolkit Context methods
    ************************************************************************/

   /**
    * No bindings
    */
   protected NamingEnumeration schema_list (
         Continuation cont)
      throws NamingException
   {
      cont.setSuccess ();
//      return new EmptyNameClassEnumerator ();
      return (new EmptyNamingEnumerator ());
   }

   /**
    * No bindings
    */
   protected NamingEnumeration schema_listBindings (
         Continuation cont)
      throws NamingException
   {
      cont.setSuccess ();
//      return new EmptyBindingEnumerator ();
      return (new EmptyNamingEnumerator ());
   }

   /**
    * No bindings at this level, not supported
    */
   protected void schema_bind (
         String name,
         Object obj,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, name);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    * No bindings at this level, not supported
    */
   protected void schema_rebind (
         String name,
         Object obj,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, name);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    * No bindings at this level, not supported
    */
   protected void schema_unbind (
         String name,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, name);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    * No bindings at this level, not supported
    */
   protected void schema_rename (
         String oldName,
         Name newName,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, oldName);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    * No subcontexts at this level, not supported
    */
   protected void schema_destroySubcontext (
         String name,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, name);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    * No subcontexts at this level, not supported
    */
   protected Context schema_createSubcontext (
         String name,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, name);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /* ***********************************************************************
    * protected Toolkit DirContext methods
    ************************************************************************/

   /**
    * No bindings at this level, not supported
    */
   protected void schema_bind (
         String name,
         Object obj,
         Attributes attrs,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, name);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    * No bindings at this level, not supported
    */
   protected void schema_rebind (
         String name,
         Object obj,
         Attributes attrs,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, name);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    * No subcontexts at this level, not supported
    */
   protected DirContext schema_createSubcontext (
         String name,
         Attributes attrs,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, name);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    * This method modifies each attribute in the mods param.
    */
   protected void schema_modifyAttributes (
         ModificationItem[] mods,
         Continuation cont)
      throws NamingException
   {
      ModificationItem mod = null;
      Attributes attrs;
      int i = 0;

      try
      {
         // Modify 1 element at a time
         for (; i < mods.length; i++)
         {
            mod = mods[i];
            attrs = new BasicAttributes (true);
            attrs.put (mod.getAttribute ());
            a_modifyAttributes ("", mod.getModificationOp (), attrs, cont);
         }
      }
      catch (AttributeModificationException e)
      {
         // Store unexecuted modifications in exception
         AttributeModificationException ame =
               new AttributeModificationException ();
         Vector failedModsVec = new Vector();
         ModificationItem[] failedMods;
         ModificationItem fmod;

         // Store the last mod we were working on.
         fmod = new ModificationItem(mod.getModificationOp (),
                      mod.getAttribute ());
         failedModsVec.addElement(fmod);

         // Store the remainder of mods
         for (; i < mods.length; i++)
         {
            mod = mods[i];
            fmod = new ModificationItem(mod.getModificationOp (),
                        mod.getAttribute ());
            failedModsVec.addElement(fmod);

         }

         int failedModCount = failedModsVec.size ();
         failedMods = new ModificationItem[failedModCount];
         for (int j = 0; j < failedModCount; j++)
            failedMods[j] = (ModificationItem) failedModsVec.elementAt(j);

         ame.setUnexecutedModifications (failedMods);
         cont.setError (this, "");
         throw (cont.fillInException (ame));
      }
   }

} /* NetSchemaDefinitionDirContext */
