
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/net/NetSchemaRootDirContext.java $
  $Revision: 5 $
  $Modtime: 10/05/99 10:01a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import java.util.*;

import javax.naming.*;
import javax.naming.directory.*;

import com.sun.jndi.toolkit.ctx.*;

import com.novell.service.nds.naming.*;


/** @internal
 * The root of the schema tree
 *
 * <p> The root of the Schema tree contains three bindings: Attributes
 * Classes and Syntaxes. Schema documentation is found in JavaSoft's JNDI API
 * specification. Look in the "Schema" section of the "Directory Interface".
 */
public class NetSchemaRootDirContext extends NetSchemaDirContext
{
   private static final String CLASSES_BINDING_NAME = "SC=Classes";
   private static final String ATTRIBUTES_BINDING_NAME = "SC=Attributes";
   private static final String SYNTAXES_BINDING_NAME = "SC=Syntaxes";

   private Hashtable bindings = new Hashtable ();

   /**
    * Constructor.
    *
    * @param objectName    Distinguished name of this object
    * @param baseClass     NDS class name
    * @param environment properties to be set in this objects environment
    */
   protected NetSchemaRootDirContext (
         String objectName,
         String baseClass,
         NetEnvironment environment)
      throws NamingException
   {
      super (objectName, baseClass, environment);

      Name target;
      Context context;

      // Add bindings
      target = nameParser.parse (CLASSES_BINDING_NAME);
      target.addAll (0, getNameInstance ());
      context = factory.getContextInstance (
                           target.toString (),
                           Schema.CLASS_CONTAINER,
                           this.environment);
      bindings.put (CLASSES_BINDING_NAME, context);

      target = nameParser.parse (ATTRIBUTES_BINDING_NAME);
      target.addAll (0, getNameInstance ());
      context = factory.getContextInstance (
                           target.toString (),
                           Schema.ATTRIBUTE_CONTAINER,
                           this.environment);
      bindings.put (ATTRIBUTES_BINDING_NAME, context);

      target = nameParser.parse (SYNTAXES_BINDING_NAME);
      target.addAll (0, getNameInstance ());
      context = factory.getContextInstance (
                           target.toString (),
                           Schema.SYNTAX_CONTAINER,
                           this.environment);
      bindings.put (SYNTAXES_BINDING_NAME, context);

   } /* NetSchemaRootDirContext () */

   /* ***********************************************************************
    * protected toolkit Context methods
    ************************************************************************/

   /**
    *
    */
   protected NamingEnumeration schema_list (
         Continuation cont)
      throws NamingException
   {
      cont.setSuccess ();
      return (new SchemaNameClassEnumerator (bindings));
   }

   /**
    *
    */
   protected NamingEnumeration schema_listBindings (
         Continuation cont)
      throws NamingException
   {
      cont.setSuccess ();
      return (new SchemaBindingEnumerator (bindings));
   }

   /**
    *
    */
   protected void schema_bind (
         String name,
         Object obj,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, name);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    *
    */
   protected void schema_rebind (
         String name,
         Object obj,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, name);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    *
    */
   protected void schema_unbind (
         String name,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, name);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    *
    */
   protected void schema_rename (
         String oldName,
         Name newName,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, oldName);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    *
    */
   protected void schema_destroySubcontext (
         String name,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, name);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    *
    */
   protected Context schema_createSubcontext (
         String name,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, name);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /* ***********************************************************************
    * protected toolkit DirContext methods
    ************************************************************************/

   /**
    *
    */
   protected DirContext schema_createSubcontext (
         String name,
         Attributes attrs,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, name);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    *
    */
   protected void schema_modifyAttributes (
         int mod_op,
         Attributes attrs,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, "");
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    *
    */
   protected void schema_modifyAttributes (
         ModificationItem[] mods,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, "");
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    *
    */
   protected void schema_bind (
         String name,
         Object obj,
         Attributes attrs,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, name);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    *
    */
   protected void schema_rebind (
         String name,
         Object obj,
         Attributes attrs,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, name);
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /* ***********************************************************************
    * Utility methods
    ************************************************************************/

   /**
    * Returns a hashtable of attribute id's / attributes
    * this is called by NetSchemaDirContext.a_getAttributes
    * There are no attributes at this level, return empty Hashtable
    */
   protected Hashtable getAttrItems ()
         throws NamingException
   {
      Hashtable ret = new Hashtable ();
      return ret;
   }
} /* NetSchemaRootDirContext */


// *************************************************************************

/**
 * This class is an extension of NamingEnumeration that's returned by
 * a_listBindings
 */
class SchemaBindingEnumerator implements NamingEnumeration
{
   private Enumeration names;
   private Hashtable table;

   /**
    *  @param h   A hashtable of bound names and objects
    */
   public SchemaBindingEnumerator(
      Hashtable h)
   {
      table = h;
      names = table.keys();
   }

   /**
    *
    */
   public boolean hasMoreElements ()
   {
      return (names.hasMoreElements());
   }

   /**
    *
    */
   public boolean hasMore ()
   {
      return hasMoreElements();
   }

   /**
    *
    */
   public Object nextElement ()
   {
      return next();
   }

   /**
    *
    */
   public Object next ()
   {
      String name = (String)names.nextElement();
      return (new Binding(name, table.get(name)));
   }

   /**
    *
    */
   public void close ()
      throws NamingException
   {
      // no code is needed here.
   }

}


// *************************************************************************

/**
 * This class is an extension of NamingEnumeration that's returned by
 * a_list
 */
class SchemaNameClassEnumerator implements NamingEnumeration
{
   private Enumeration names;
   private Hashtable table;

   /**
    *  @param h   A hashtable of bound names and objects
    *
    */
   public SchemaNameClassEnumerator(
         Hashtable h)
   {
      table = h;
      names = table.keys ();
   }

   /**
    *
    */
   public boolean hasMoreElements ()
   {
      return (names.hasMoreElements ());
   }

   /**
    *
    */
   public boolean hasMore ()
   {
      return hasMoreElements();
   }

   /**
    *
    */
   public Object nextElement ()
   {
      return next ();
   }

   /**
    *
    */
   public Object next ()
   {
      String name = (String)names.nextElement ();
      return (new NameClassPair (
                  name,
                  table.get (name).getClass ().getName ()));
   }

   /**
    *
    */
   public void close ()
      throws NamingException
   {
      // no code is needed here.
   }

}


