
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/net/PendingOpObject.java $
  $Revision: 3 $
  $Modtime: 1/25/00 4:40p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import com.novell.service.jncpv2.net.NetService;


/** @internal
*  Class for monitoring pending Partition Operations
*/

public class PendingOpObject
{
    // Name of the partition
    private String name;
    // Lower level(NDS) context handle
    private NetService service;

    // Pending Operation - split or join
    private String op;

    static int idCounter = 0;

    // Id to identify this object uniquely
    private int uniqueId;

    public PendingOpObject(String name, NetService service, String op)
    {
        // Create a unique id to identify this object
        this(name, service, op, idCounter++);
    }

    protected PendingOpObject(String name, NetService service, String op, int id)
    {
        this.name = name;
        this.service = service;
        this.op = op;
        uniqueId = id;
    }

    protected NetService getService()
    {
        return (service);
    }

    protected String getPendingOpName()
    {
        return op;
    }

    protected String getPartitionName()
    {
        return name;
    }

    public int getUniqueId()
    {
        return uniqueId;
    }
    // Override the Object's equals to return true
    // if all the fields are equal
    public boolean equals(Object obj)
    {
        PendingOpObject newObj;

        if(obj instanceof PendingOpObject)
        {
            newObj = (PendingOpObject)obj;
            if(newObj.getPartitionName().equals(name) &&
                newObj.getPendingOpName().equals(op) &&
                    (newObj.getService() == service) &&
                        (newObj.getUniqueId() == uniqueId))
            {
                return true;
            }
        }
        return false;
    }

    public int hashCode()
    {
        return name.hashCode();
    }
}
