
/* **************************************************************************
  $Archive: /njcl_v2/src/com/novell/service/nds/net/NetCaseIgnoreString.java $
  $Revision: 6 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsCaseIgnoreString;


/** @internal
 * NetCaseIgnoreString is an Adapter for NdsCaseIgnoreString.
 *
 * This class converts to/from the NWNet CI_String_T.
 *
 * API Data Structure:
 *    typedef pnchar CI_String_T;
 */
public final class NetCaseIgnoreString
   extends NdsCaseIgnoreString implements NetAttributeValue, Serializable
{
   /**
    * Constructs a Case Ignore String from the "API Data Structure".
    *
    * @param   value   byte[] containing a CI_String_T.
    */
   protected NetCaseIgnoreString (
         byte[] value)
      throws NSIException
   {
      try
      {
         EndianInputStream edis = new EndianInputStream (value);

         this.value = edis.readLoHiChars ();
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetCaseIgnoreString adapter for an NdsCaseIgnoreString.
    *
    * @param value   an NdsCaseIgnoreString object.
    */
   protected NetCaseIgnoreString (
         NdsCaseIgnoreString value)
   {
      super (value);
   }

   /**
    * Returns a Case Ignore String "API Data Structure".
    *
    * @return   byte[] containing CI_String_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiChars (this.value);
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetCaseIgnoreString */


