
/* **************************************************************************
  $Archive: /njcl_v2/src/com/novell/service/nds/net/NetCounter.java $
  $Revision: 6 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsCounter;


/** @internal
 * NetCounter is an Adapter for NdsCounter.
 *
 * This class converts to/from the NWNet Counter_T.
 *
 * API Data Structure:
 *    typedef  nuint32  Counter_T;
 */
public final class NetCounter
   extends NdsCounter implements NetAttributeValue, Serializable
{
   /**
    * Constructs a Counter from the "API Data Structure".
    *
    * @param   value   byte[] containing a Counter_T
    */
   protected NetCounter (
         byte[] value)
      throws NSIException
   {
      try
      {
         EndianInputStream edis = new EndianInputStream (value);

         this.value = edis.readLoHiInt ();
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetCounter adapter for an NdsCounter.
    *
    * @param   value   an NdsCounter object.
    */
   protected NetCounter (
         NdsCounter value)
   {
      super (value);
   }

   /**
    * Returns a Counter "API Data Structure".
    *
    * @return   byte[] containing Counter_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiInt (this.value);
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetCounter */


