
/* **************************************************************************
  $Archive: /njcl_v2/src/com/novell/service/nds/net/NetDistinguishedName.java $
  $Revision: 6 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsDistinguishedName;


/** @internal
 * NetDistinguishedName is an Adapter for NdsDistinguishedName.
 *
 * This class converts to/from the NWNet DN_T.
 *
 * API Data Structure:
 *    typedef pnchar DN_T;
 */
public final class NetDistinguishedName
   extends NdsDistinguishedName implements NetAttributeValue, Serializable
{
   /**
    * Constructs a Distinguished Name from the "API Data Structure".
    * 
    * @param   value   byte[] containing a DN_T.
    */
   protected NetDistinguishedName (
         byte[] value)
      throws NSIException
   {
      try
      {
         EndianInputStream edis = new EndianInputStream (value);

         this.value = edis.readLoHiChars ();
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetDistinguishedName adapter for an NdsDistinguishedName.
    * 
    * @param   value   an NdsDistinguishedName object.
    */
   protected NetDistinguishedName (
         NdsDistinguishedName value)
   {
      super (value);
   }

   /**
    * Returns a Distinguished Name "API Data Structure".
    * 
    * @return   byte[] containing DN_T.
    */
   public byte[] toByte ()
         throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiChars (value);
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetDistinguishedName */


