
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/net/NetHold.java $
  $Revision: 6 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsHold;


/** @internal
 * NetHold is an Adapter for NdsHold.
 *
 * This class converts to/from the NWNet Hold_T.
 *
 * API Data Structure:
 *    typedef struct
 *    {
 *       pnchar   objectName;
 *       NWHOLD_AMOUNT   amount;
 *    } Hold_T;
 */
public final class NetHold
   extends NdsHold implements NetAttributeValue, Serializable
{
   /**
    * Constructs a Hold from the "API Data Structure".
    *
    * @param   value   byte[] containing a Hold_T
    */
   protected NetHold (
         byte[] value)
      throws NSIException
   {
      try
      {
         EndianInputStream edis = new EndianInputStream (value);

         this.objectName = edis.readLoHiChars ();
         this.amount = edis.readLoHiInt ();
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetHold adapter for an NdsHold.
    *
    * @param   value   an NdsHold object.
    */
   protected NetHold (
        NdsHold value)
   {
      super (value);
   }

   /**
    * Returns a Hold "API Data Structure".
    *
    * @return   byte[] containing Hold_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiChars (this.objectName);
         eos.writeLoHiInt (this.amount);
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetHold */


