/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/qms/QMSAccessor.java $
  $Revision: 9 $
  $Modtime: 2/09/01 5:04p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.qms;


import java.io.*;
import com.novell.java.io.spi.DataAccessor;
import com.novell.service.file.nw.calls.*;
import com.novell.service.*;
import com.novell.service.session.*;
import com.novell.service.session.xplat.*;

/** @internal
 * This is an implementation class that represents the output stream for a
 * queue job.
 */

public class QMSAccessor
   extends NativeDeviceAccessor
{
   private static final String serviceKey    = CallsService.KEY;

   // Private data members ===================================================
   private Session session;
   private CallsService service;
   private int queueID;
   private int jobID;

   // Constructors ===========================================================
   public QMSAccessor (
         int handle,
         Session session,
         int queueID,
         int jobID)
      throws IOException
   {
      super (handle, session, false);
      this.session = session;
      this.queueID = queueID;
      this.jobID = jobID;
      try
      {
         service = (CallsService) session.getService (serviceKey);
      }
      catch (SessionException e)
      {
         throw (new IOException (e.getMessage ()));
      }
   }

   // Public methods =========================================================

   /**
    * Closes the queue file and cancels the job.
    */
   public void abort ()
      throws IOException
   {
      if (closed)
         return;

      try
      {
         service.closeFileAndAbortQueueJob2 (queueID, jobID, handle);
      }
      catch (Exception e)
      {
         throw new IOException (e.getMessage ());
      }

      closed = true;
   } /* abort() */

   /**
    * Closes the queue file and tells the queue the job is ready to be
    * serviced.
    *
    * <p>This method over-rides the NativeDeviceAccessor close method.
    * </p>
    */
   public void close ()
      throws IOException
   {
      if (closed)
         return;

      flush ();

      try
      {
         service.closeFileAndStartQueueJob2 (queueID, jobID, handle);
      }
      catch (Exception e)
      {
         throw new IOException (e.getMessage ());
      }

      closed = true;
   } /* close() */
   
   // Protected methods ======================================================
   /**
    * Aborts the queue job if it has not already been closed.
    */
   protected void finalize ()
      throws IOException
   {
      if (!closed)
         abort ();
   } /* finalize() */
   
} /* class QMSAccessor */
