/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/qms/naming/QMSEnvironment.java $
  $Revision: 12 $
  $Modtime: 2/02/00 9:33a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.qms.naming;

import java.util.Hashtable;
import java.io.Serializable;

import javax.naming.*;

import com.novell.utility.naming.Environment;
import com.novell.service.session.*;
import com.novell.service.session.xplat.CallsService;

/** 
 * Defines the set of environment property constant Strings that
 * uniquely controls the behavior of Queues and Queue Jobs. The
 * QMSEnvironment class extends the Environment class, which
 * provides constants for environment variables associated with
 * Novell JNDI providers.
 * 
 * @see com.novell.utility.naming.Environment
 */

public class QMSEnvironment
   extends Environment
   implements Cloneable, Serializable
{
   // JNDI property strings =================================================

   /**
    * Environment property containing the queue name (String).
    *
    * <p>(QUEUE_NAME = "com.novell.service.qms.naming.queueName")</p>
    */
   public final static String QUEUE_NAME =
      "com.novell.service.qms.naming.queueName";

   /**
    * Environment property containing the queue type (String).
    *
    * <p>(QUEUE_TYPE = "com.novell.service.qms.naming.queueType")</p>
    */
   public final static String QUEUE_TYPE =
      "com.novell.service.qms.naming.queueType";

   /**
    * Environment property containing the queue ID (String).
    *
    * <p>(QUEUE_ID = "com.novell.service.qms.naming.queueID")</p>
    */
   public final static String QUEUE_ID =
      "com.novell.service.qms.naming.queueID";

   /**
    * Environment property containing the queue job ID (String).
    *
    * <p>(QUEUE_JOB_ID = "com.novell.service.qms.naming.queueJobID")</p>
    */
   public final static String QUEUE_JOB_ID =
      "com.novell.service.qms.naming.queueJobID";

   // Internal variables =====================================================
   private CallsService callsService = null;

   // Constructors ===========================================================

   /**@internal
    *
    */
   public QMSEnvironment (Hashtable hash)
   {
      super (hash);
   } /* QMSEnvironment(Hashtable) */
   
   /**@internal
    *
    */
   public QMSEnvironment (Environment env)
      throws NamingException
   {
      super (env);
   } /* QMSEnvironment(Environment) */

   // Environment methods ====================================================

   /**
    * @internal
    *
    * Returns the current session used by this context.
    *
    * @return The Session object being used by this context.
    *
    * @exception NamingException When a naming error occurs.
    */
   public Session getSession ()
      throws NamingException
   {
      try
      {
         if (session == null)
         {
            Object obj = environment.get (Environment.SESSION_OBJECT);

            if ((null != obj) &&
                (obj instanceof Session))
            {
               session = (Session) obj;
            }
            else
               throw new SessionException ("Session not found");
         }
         return session;
      }
      catch (SessionException e)
      {
         NamingException ne = new AuthenticationException ();

         ne.setRootCause (e);
         throw (ne);
      }
   } /* getSession() */
   
   /** 
    * @internal
    *
    * Returns the session service (CallsService) for this environment's
    * session.
    *
    * @return  The CallsService for this environment.
    *
    * @exception NamingException When a naming error occurs.
    */
   public CallsService getCallsService()
      throws NamingException
   {
      if (callsService != null)
         return callsService;

      callsService = (CallsService) getService (CallsService.KEY);
      return callsService;
   } /* getCallsService() */
   
} /* class QMSEnvironment */
