/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/qms/naming/QMSQueueAttributes.java $
  $Revision: 3 $
  $Modtime: 4/27/98 11:18a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.qms.naming;


import javax.naming.*;
import javax.naming.directory.*;
import java.util.*;

import com.novell.service.qms.*;

import com.novell.utility.naming.directory.*;

/** @internal
 *
 * public class QMSQueueAttributes
 *     extends Attributes
 *
 */

public class QMSQueueAttributes extends NAttributes
{
   /*
   * Array of attribute ids of the QMSQueueDirContext object
   */
   private static String[] attrNames =
        { QMSStrings.QUEUE_ATTRID_STATE };

   private QMSQueue queue;

   protected QMSQueueAttributes( QMSQueue queue, String[] attrIDs )
      throws NamingException
   {
      super();
      this.queue = queue;

      if ( null != attrIDs )
      {
         for ( int i = 0; i < attrIDs.length; i++ )
         {
            put( new QMSQueueAttribute( attrIDs[i], queue ) );
         }
      }
      else
         put( new QMSQueueAttribute( attrNames[0], queue ) );
   }
}
