/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/security/Password.java $
  $Revision: 8 $
  $Modtime: 1/20/00 2:24p $

  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.security;

/**
 * This class is a holder for passwords.
 *
 * <p>Note: Using passwords directly limits the application's ability to
 * use alternative sources of tokens, including smart cards, etc. Thus,
 * use of this class and the related interfaces will limit the application
 * functionality with new authentication features.
 * </p>
 * @see PasswordIdentity
 */
public class Password
{
	private String password;

   /**
    * Construct a password using a String.
    *
    * @param password            The string to use for the password.
    */
   public Password (
         String password)
	{
		this.password = password;
	}

    /**
     * Construct a password from raw bytes.
     * The specified bytes will be used exactly as is.
     *
     * @param passwordBytes the bytes for the password.
     * @param exclude
     */
    public Password(byte[] passwordBytes) {
        StringBuffer Buffer = new StringBuffer();
        Buffer.append((char) 0);
        Buffer.append((char) 2);
        Buffer.append((char) 0x9fff);
        Buffer.append((char) 0xd7fe);
        Buffer.append((char) 0xf8fd);
        for (int i = 0; i < passwordBytes.length; i++)
            Buffer.append((char) (passwordBytes[i] & 0xff));
        password = Buffer.toString();
    }
    
   /**
    * Set the password to equal another using a Password.
    *
    * @param passwordObj         The Password object to use for the password.
    */
	public void setPassword (
         Password passwordObj)
	{
		this.password = passwordObj.password;
	}
	
	/**
	 * Return the hash of the password string rather than the actual string.
    *
    * @return                    A hash of the password string.
	 */
	public String toString()
	{
		if(password != null)
			return java.lang.Integer.toString(password.hashCode());

		return "NULL";
	}

	/**
	 * Return a raw version of the password.
    *
    * <p>This is intended for use by JNI code and should not be used by
    * the application.
    *
    * @return                    The raw password string.
	 */
	public String getRaw()
	{
		return password;
	}

    public void convertToUpperCase()
    {
    	password = new String(password.toUpperCase());
    }
} // class Password
