/* ***************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/security/PasswordIdentityFactory.java $
  $Revision: 3 $
  $Modtime: 10/18/99 2:27p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

 ****************************************************************************/

package com.novell.service.security;

/**
 * This interface identifies an object that can create PasswordIdentity
 * objects. The intent behind this interface is to have the non-password
 * version of an identity implement this factory and provide a generic
 * means by which an application can decide to over-ride the GUI portion
 * of the authentication process.
 *
 * @see NdsIdentity
 * @see BinderyIdentity
 */
public interface PasswordIdentityFactory
{
   /**
    * Instantiate a password identity class.
    *
    * @return                    The appropriate PasswordIdentity.
    */
   public PasswordIdentity getPasswordIdentityInstance ();
} /* interface PasswordIdentityFactory */
