/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/server/ServerInitialContextFactory.java $
  $Revision: 4 $
  $Modtime: 4/27/98 12:12p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.server;

import javax.naming.*;
import javax.naming.spi.*;
import java.util.Hashtable;
import com.novell.utility.naming.Environment;
import com.novell.utility.naming.URLParser;

/** @internal
* Creates ServerDirContext corresponding to the
* Context.PROVIDER_URL entry in info
*/
public class ServerInitialContextFactory
implements javax.naming.spi.InitialContextFactory
{
   public Context getInitialContext(
         Hashtable info)
      throws NamingException
	{
      try
      {
         String host = null;
         Context ctx = null;

 			String url = (String)info.get(Context.PROVIDER_URL);
         host = new URLParser(url).getHost();
         ctx = (Context)NamingManager.getObjectInstance(
            new com.novell.service.server.ReferenceFactoryImpl().
               createReference(info),
            null,
            null, 
            info);
         if(ctx == null)
            throw new NoInitialContextException();
         return ctx;
      }
      catch(Exception e)
      {
         NoInitialContextException ne = new NoInitialContextException();
         ne.setRootCause(e);
         throw ne;
      }
	}
}
