/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/SessionAttr.java $
  $Revision: 13 $
  $Modtime: 1/24/00 7:59p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session;

import com.novell.service.jncpv2.clx.*;
import com.novell.service.session.*;
import java.io.Serializable;
import java.lang.Cloneable;
import java.util.Enumeration;
import java.util.Vector;

/**
 * Provides for a session attribute, which is an identifying characteristic
 * of the Session from from it was retrieved. An attribute is an object that
 * can only be read/retrieved from a session and you cannot change a session
 * attribute. SessionAttr reflects the current state of the session.
 *
 * @see SessionAttrs
 */
public class SessionAttr implements Cloneable, Serializable
{
 /**
  * @internal
  */
   protected Object value = null;
 /**
  * @internal
  */
   protected String attrId = null;
 /**
  * @internal
  */
   protected boolean ignoreCase = false;

   /**
    * Constructs a new instance of a session attribute.
    *
    * @param attrId The ID for the session attribute.
    * @param value  The value of the session attribute.
    */
   public SessionAttr
   (
      String attrId,
      Object value
   )
   {
      this.attrId = attrId;
      this.value = value;
   }

   /**
    * Constructs a new instance of a session attribute.
    *
    * @param attrId The ID for the session attribute.
    * @param value  The value of the session attribute.
    */
   public SessionAttr
   (
      String attrId,
      String value,
      boolean ignoreCase
   )
   {
      this(attrId, value);
      this.ignoreCase = ignoreCase;
   }

   /**
    * @internal
    *
    * Creates a new object of the same class as this session attribute
    * class. It then initializes each of the new object's fields by
    * assigning it the same value as the corresponding field in this
    * object. No constructor is called.
    */
   public Object clone
   (
   )
   {
      SessionAttr attr;
      if (this.value instanceof String)
         attr = new SessionAttr(
            this.attrId,
            (String)this.value,
            this.ignoreCase);
      else
         attr = new SessionAttr(
            this.attrId,
            this.value);
      return attr;
   }

  /**
   * @internal
   *
   * Compares two Objects for equality. The equals method compares
   * this session attribute object value with the value of the reference
   * object in the obj parameter. The two attributes are equal if their
   * session attribute-ids and values are equal.
   *
   * @param obj  The reference object with which to compare.
   *
   * @return A boolean set to TRUE if and only if the argument is not
   *         NULL and is an NDS integer object that contains the
   *         same value as this object, otherwise set to FALSE.
   */
   public boolean equals
   (
      Object obj
   )
   {
      if ((obj != null) && (obj instanceof SessionAttr))
      {
         SessionAttr target = (SessionAttr)obj;
         if (this.attrId.equals(
            target.getSessionAttrId()) )
         {
            if (ignoreCase)
            {
               if (((String)this.value).equalsIgnoreCase(
                  (String)target.getValue()))
                     return true;
            }
            else
            {
             if (this.value.equals(
                target.getValue()))
                   return true;
            }
         }
      }
      return false;
   }

   /**
    * Returns the ID of this session attribute.
    *
    * @return The session attribute ID as a String.
    */
   public String getSessionAttrId
   (
   )
   {
      return this.attrId;
   }

   /**
    * Returns the value associated with this session attribute.
    *
    * @return The value of this session attribute.
    */
   public Object getValue
   (
   )
   {
      return this.value;
   }

   /**
    * @internal
    *
    * Returns a string representation of this session attribute object.
    * In general, the toString() method returns a string that textually
    * represents this object. The result should be a concise but
    * informative representation that is easy for a person to read. It
    * is recommended that all subclasses override this method.
    *
    * @return A string representation of this session attribute object.
    */
   public String toString
   (
   )
   {
      return this.attrId + ": " +
         this.value + ": case " +
           (ignoreCase ? "ignore" : "sensitive");
   }
}

