/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/SessionException.java $
  $Revision: 14 $
  $Modtime: 1/24/00 7:59p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session;

import com.novell.service.jncpv2.clx.*;
import com.novell.java.lang.HasRootCause;
import java.lang.Exception;

/**
 * Provides a top-level exception that is thrown by session objects.
 * All session exceptions extend this top-level exception.
 */
public class SessionException
extends Exception
implements java.io.Serializable, HasRootCause
{
  /**
   * @internal
   */
   protected Throwable rootException = null;

   /**
    * Constructs a SessionException with a specified detail message.
    * A detail message is a String that describes this particular exception.
    *
    * @param s The detail message describing the exception.
    */
   public SessionException
   (
      String s
   )
   {
      super(s);
   }

   /**
    * Constructs a SessionException with a root-cause exception.
    * The root cause exception can be retrieved using getRootCause().
    *
    * @param rootException The root-cause exception.
    */
   public SessionException
   (
      Throwable rootException
   )
   {
      super("Wrapped exception");
      this.rootException = rootException;
   }

   /**
    * Constructs a SessionException with a specified detail message
    * and a root-cause exception. The root-cause exception can be
    * retrieved using getRootCause().
    *
    * @param s The detail message describing the exception.
    * @param rootException The root-cause exception.
    */
   public SessionException
   (
      String s,
      Throwable rootException
   )
   {
      super(s);
//      super(s + ": " + rootException.toString());
      this.rootException = rootException;
   }

   /**
    * Retrieves the root-cause exception, which is inherited from
    * HasRootCauses.
    *
    * @return Throwable The root-cause exception.
    */
   public Throwable getRootCause
   (
   )
   {
      return rootException;
   }

   /**
    * Returns a short description of this throwable object.
    *
    * @return A string representation of this root-cause exception.
    */
   public String toString()
   {
      String s = super.toString();
      if (null != rootException)
         s += "; check root cause";
      return s;
   }
}

