/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/nds/NDSInitialSessionFactory.java $
  $Revision: 15 $
  $Modtime: 1/24/00 7:59p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.nds;

import com.novell.service.jncpv2.clx.*;
import com.novell.service.session.xplat.*;
import com.novell.service.session.*;
import com.novell.service.session.util.Debug;
import com.novell.service.session.spi.*;

/** @internal
 * Default provided InitialSessionFactory, supporting NDS sessions.
 */
public class NDSInitialSessionFactory implements InitialSessionFactory
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
	final static private boolean DEBUG = false;
	final static private boolean S_DEBUG = false; // May have side effects

   private SessionImpl initialSession;

   /**
    * Inherited from InitialSessionFactory
    *
    * @see InitialSessionFactory#getInitialSession
    */
   public SessionImpl getInitialSession
   (
      SessionManager sessionManager
   )
   throws SessionException
   {
      if (null == this.initialSession)
      {
         this.initialSession = new SessionImpl(
            sessionManager,
            NDS.INITIAL_SESSION);
         new NDSInitialSessionState(
            this.initialSession);
      }
      return this.initialSession;
   }
}

