/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/nds/NDSServerPersistenceService.java $
  $Revision: 10 $
  $Modtime: 4/04/99 5:28p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.nds;

import com.novell.service.session.Session;
import com.novell.service.session.xplat.PersistenceService;
import com.novell.service.session.xplat.Connection;
import com.novell.service.session.spi.SessionImpl;
import com.novell.service.session.SessionException;
import com.novell.service.session.spi.InvalidSessionState;

/**@internal
 *
 */
public class NDSServerPersistenceService
implements PersistenceService
{
   SessionImpl session;

   NDSServerPersistenceService
   (
      SessionImpl session
   )
   {
      this.session = session;
   }

   public void persist
   (
   )
   throws SessionException
   {
      NDSContextSessionState state = (NDSContextSessionState)session.getState();
      state.context.getConnection().keep();
   }

   private void desist
   (
   )
   throws SessionException
   {
      NDSContextSessionState state = (NDSContextSessionState)session.getState();
      state.context.getConnection().closeRef();
      Session parent = session.getParent();
      InvalidSessionState.makeInvalid(
         (SessionImpl)session,
         new SessionException("NDSServerPersistenceService.desist() called"));
//      parent.invalidate(session);
      session.close();
      parent.validateLinks();
   }
}



