/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/nds/NDSShibboleth.java $
  $Revision: 23 $
  $Modtime: 3/20/03 5:54p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.nds;

import com.novell.service.session.*;
import com.novell.service.session.xplat.*;
import com.novell.service.security.NdsIdentity;
import com.novell.service.session.spi.SessionImpl;
import com.novell.service.session.util.Debug;

/** @internal
 * @deprecated Use com.novell.service.security and related packages.
 */
public class NDSShibboleth extends ShibbolethImpl
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
   final static private boolean DEBUG = false;
   final static private boolean I_DEBUG = false; // Ignore exception
   final static private boolean LOGOUT_DEBUG = false;
   final static private boolean S_DEBUG = false; // May have side effects

   protected static final String KEY = ShibbolethImpl.KEY;

   //The following dsapi methods do not honor the DCV_DISALLOW_REFERRALS flag so a server
   //session could have it's connection swaped out underneath it. So we actually make the
   //call on the parent tree session if the passed in session is a server session.
   //NWDSLogin, NWDSLogout, NWDSChangeObjectPassword, NWDSGenerateObjectKeyPair, NWDSVerifyObjectPassword
   SessionImpl origSession;
   SessionImpl treeSession;

   NDSShibboleth(SessionImpl session)
   throws SessionException
   {
      origSession = session;
      treeSession = getTreeSession(session);
   }

   public void changePassword
   (
      String userName,
      String oldPassword,
      String newPassword,
      boolean extendedCharPasswordFlag
   )
   throws SessionException
   {
      getContext(treeSession).
         changePassword(userName, oldPassword, newPassword, extendedCharPasswordFlag);
   }

   public void setPassword
   (
      String objName,
      String password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException
   {
      getContext(treeSession).
         setPassword(objName, password, extendedCharPasswordFlag);
   }

   public void verifyPassword
   (
      String objName,
      String password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException
   {
      getContext(treeSession).
         verifyPassword(objName, password, extendedCharPasswordFlag);
   }

   public void authenticate
   (
      String userName,
      String password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException
   {
      if (DEBUG || LOGOUT_DEBUG)
      {
         Debug.println("About to login to " + origSession.getDomainName() + " using " + treeSession.getDomainName());
      }
      getContext(treeSession).
         login(userName, password, extendedCharPasswordFlag);
   }

   public void authenticateNAS(NdsIdentity ident, String userName, String password, boolean extendedCharPasswordFlag)
   throws SessionException
   {
      if (DEBUG || LOGOUT_DEBUG)
      {
         Debug.println("NAS");
      }
      getContext(treeSession).loginNAS(ident, userName, password, extendedCharPasswordFlag);
   }

   public void authenticateService
   (
      String serviceName
   )
   throws SessionException
   {
      getContext(origSession).loginAsService(serviceName);
   }

   public void unauthenticate
   (
   )
   throws SessionException
   {
      if (DEBUG || LOGOUT_DEBUG)
      {
         Debug.println("About to logout of " + origSession.getDomainName() + " using " + treeSession.getDomainName());
      }
      getContext(treeSession).
         logout();
   }

   public void unauthenticateNAS(NdsIdentity ident) throws SessionException
   {
      if (DEBUG || LOGOUT_DEBUG)
      {
         Debug.println("About to logout of " + origSession.getDomainName() + " using " + treeSession.getDomainName());
      }
      getContext(treeSession).logoutNAS(ident);
   }

   private SessionImpl getTreeSession(Session s) throws SessionException
   {
      String type = (String)s.getAttributes(new String[] {Session.SESSION_TYPE_ATTR_ID}).
         getValue(Session.SESSION_TYPE_ATTR_ID);
      if(!type.equalsIgnoreCase(Xplat.TREE_SESSION_TYPE))
      {
         s = s.getParent();
         type = (String)s.getAttributes(new String[] {Session.SESSION_TYPE_ATTR_ID}).
            getValue(Session.SESSION_TYPE_ATTR_ID);
         if(!type.equalsIgnoreCase(Xplat.TREE_SESSION_TYPE))
            throw new SessionException(type + "!=" + Xplat.TREE_SESSION_TYPE);
      }
      return (SessionImpl)s;
   }
   
   private NDSContext getContext(SessionImpl s) throws SessionException
   {
      NDSContextSessionState state = (NDSContextSessionState)s.getState();
      return state.context;
   }
}
